# coding: UTF-8

require 'open-uri'

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../../../")
	$:.unshift(ROOT_PATH + "/../../../../main/")
	$:.unshift(ROOT_PATH + "/../../../../main/lib")

	# mail2weblog のルートパスを設定する
	M2W_ROOT_PATH = ROOT_PATH + "/../../../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'm2w_plugin_manager'
require 'mailutils/mail_processor'
require 'testutils/image_testutils'
require 'testutils/weblog_testutils'

require "#{File.dirname(File.expand_path(__FILE__))}/../../conf/setting"
require "#{File.dirname(File.expand_path(__FILE__))}/conf/setting"

#=ブログ記事投稿コマンドプラグインのテスト
#
# リアル投稿テストです。実在するブログに投稿を行い、投稿結果が反映されていることの確認を行います。
# 本テストの内容は、設定（../../conf/setting.rb, conf/setting.rb）によって決定されます。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_post_plugin.rb 888 2012-12-02 00:31:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestPostCommandPlugin < MiniTest::Unit::TestCase

	if M2W4TEST_REAL && M2W4TEST_REAL_POST_TEST  then
		def setup
			@mail_parser = Mail2WeblogMailParser.new(
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR_REGEX,
				{})

			@mail_sender = Mail2WeblogMailSender.new(
				M2W4TEST_SENDER_SMTP_SERVER_ADDRESS,
				M2W4TEST_SENDER_SMTP_SERVER_PORT,
				M2W4TEST_SENDER_SMTP_SECURITY_TYPE,
				M2W4TEST_SENDER_SMTP_SERVER_USER,
				M2W4TEST_SENDER_SMTP_SERVER_PASSWORD,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_ADDRESS,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_PORT,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_USER,
				M2W4TEST_SENDER_POP3_BEFORE_SMTP_SERVER_PASSWORD,
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR,
				MailProcessor.parse_mail_address(M2W4TEST_REPLY_MAILADDRESS),
				true)

			@plugin_manager = Mail2WeblogPluginManager.new(
				{},
				{},
				{'COMMON' =>
					{'default_format_mode' => 'wiki'}
				}
			)

			@weblog_testutils = WeblogTestUtils.new(
				M2W4TEST_WEBLOG_EXTENSION,
				@mail_parser,
				@mail_sender,
				@plugin_manager,
				nil,
				M2W4TEST_SENDER_MAILADDRESS,
				M2W4TEST_REPLY_MAILADDRESS)
		end

		def test_simple
			M2W_LOGGER.debug("Start  #{self.class.name}#test_simple")

			# コマンドを実行する
			blogid = M2W4TEST_WEBLOG_BLOG_ID != M2W_WEBLOG_DEFAULT_BLOGID ? M2W4TEST_WEBLOG_BLOG_ID : nil
			from_address = MailAddress.new(M2W4TEST_SENDER_MAILADDRESS)
			to_addresses = [MailAddress.new(M2W4TEST_REPLY_MAILADDRESS)]
			keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
			title = "タイトルテスト@#{keyword}"
			attr1 = "属性１@#{keyword}"
			attr2 = "属性２@#{keyword}"
			message = "コンテンツテスト１行目@#{keyword}\n\nコンテンツテスト２行目@#{keyword}"
			content = @mail_sender.make_content(
				{
					'tit' => title,
					'attr1' => attr1,
					'attr2' => attr2,
				},
			message)
			mail = Mail.new(@mail_sender.make_title("post", blogid), from_address, to_addresses, content, [])
			command_adapter = Post_CommandAdapterPlugin4Mail.new
			command_adapter.mail_parser = @mail_parser
			command_adapter.plugin_manager = @plugin_manager
			command = Post_CommandPlugin.new
			command.logger = M2W_LOGGER
			command.weblog = M2W4TEST_WEBLOG_EXTENSION
			command.plugin_manager = @plugin_manager
			request = command_adapter.create_request(command, mail)
			response = command_adapter.create_response(command, request, command.run(request))
			assert response.success
			assert_equal 1, response.notices.size
			assert_equal content, response[:original_content]
			assert response[:postid] != nil
			assert_equal 0, response[:attachment_urls].size, response[:attachment_urls]
			assert_equal 0, response[:thumbnail_urls].size, response[:thumbnail_urls]
			assert_equal 0, response.errors.size, response.errors
			assert_equal 0, response.warnings.size, response.warnings

			# レスポンス通知内容を確認する
			mail = @mail_sender.make_mail_from_notice(response.notices[0])
			assert mail != nil
			assert_equal @mail_sender.make_title("get", blogid), mail.subject
			assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
			assert_equal 1, mail.to_addresses.size
			assert_equal from_address.address, mail.to_addresses[0].address
			assert_match /postid\.#{response[:postid]}/, mail.content
			assert_equal 0, mail.attachments.size

			# ブログ記事を取得して内容を確認する
			(get_result, mail, header, content, contents, attachments, link) = @weblog_testutils.get(blogid, response[:postid])
			assert get_result
			assert_equal 3, header.size
			assert_nil header['postid']
			assert_nil header['blogid']
			assert_equal title, header['tit']
			assert_equal attr1, header['attr1']
			assert_equal attr2, header['attr2']
			assert_equal message, content
			assert_equal 0, attachments.size

			# ブログ記事の投稿を確認する
			response = open(link) { |stream| stream.read }.encode(M2W_SYSTEM_INNER_ENCODING, M2W4TEST_WEBLOG_ENCODING)
			assert_match title, response
			assert_match %r!<p>.*コンテンツテスト１行目@#{keyword}(</p>.*<p>|<br><br>)コンテンツテスト２行目@#{keyword}.*</p>!m, response

			M2W_LOGGER.debug("Finish #{self.class.name}#test_simple")
		end

		if M2W4TEST_REAL_ATTACHMENTS_TEST then
			def test_attachments
				M2W_LOGGER.debug("Start  #{self.class.name}#test_attachments")

				# コマンドを実行する
				blogid = M2W4TEST_WEBLOG_BLOG_ID != M2W_WEBLOG_DEFAULT_BLOGID ? M2W4TEST_WEBLOG_BLOG_ID : nil
				from_address = MailAddress.new(M2W4TEST_SENDER_MAILADDRESS)
				to_addresses = [MailAddress.new(M2W4TEST_REPLY_MAILADDRESS)]
				keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
				title = "タイトルテスト@#{keyword}"
				message = "コンテンツテスト\@#{keyword}"

				mail_content = @mail_sender.make_content(
					{"tit" => title},
					M2W4TEST_REAL_THUMBNAIL_MESSAGES == nil ? message : message + M2W4TEST_REAL_THUMBNAIL_MESSAGES)
				attachments = M2W4TEST_REAL_ATTACHMENTS_ACTUAL
				mail = Mail.new(@mail_sender.make_title("post", blogid), from_address, to_addresses, mail_content, attachments)
				command_adapter = Post_CommandAdapterPlugin4Mail.new
				command_adapter.mail_parser = @mail_parser
				command_adapter.plugin_manager = @plugin_manager
				command = Post_CommandPlugin.new
				command.logger = M2W_LOGGER
				command.weblog = M2W4TEST_WEBLOG_EXTENSION
				command.plugin_manager = @plugin_manager
				request = command_adapter.create_request(command, mail)
				response = command_adapter.create_response(command, request, command.run(request))
				assert response.success
				assert_equal 1, response.notices.size
				assert_equal mail_content, response[:original_content]
				assert response[:postid] != nil
				assert response[:attachment_urls] != nil
				assert response[:thumbnail_urls] != nil
				assert_equal M2W4TEST_REAL_ERRORS_SIZE, response.errors.size
				assert_equal M2W4TEST_REAL_WARNINGS_SIZE, response.warnings.size

				# レスポンス通知内容を確認する
				mail = @mail_sender.make_mail_from_notice(response.notices[0])
				assert mail != nil
				assert_equal @mail_sender.make_title("get", blogid), mail.subject
				assert_equal M2W4TEST_REPLY_MAILADDRESS, mail.from_address.address
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				assert_match /^postid\.#{response[:postid]}$/, mail.content
				assert_equal 0, mail.attachments.size

				# ブログ記事を取得して内容を確認する
				(get_result, mail, header, content, contents, attachments, link) = @weblog_testutils.get(M2W4TEST_WEBLOG_BLOG_ID, response[:postid])
				assert get_result
				assert_nil header['postid']
				assert_nil header['blogid']
				assert_equal 1, header.size
				assert_equal title, header["tit"]
				assert_equal M2W4TEST_REAL_THUMBNAIL_MESSAGES == nil ? message : message + M2W4TEST_REAL_THUMBNAIL_MESSAGES, content
				# 添付ファイルの内容を確認する
				if M2W4TEST_REAL_ATTACHMENTS_ACTUAL != nil && M2W4TEST_REAL_ATTACHMENTS_EXPECTED != nil then
					assert_equal M2W4TEST_REAL_ATTACHMENTS_EXPECTED.size, response[:attachment_urls].size
					assert_equal M2W4TEST_REAL_THUMBNAILS_SIZE, response[:thumbnail_urls].size if M2W_SYSTEM_RMAGICK_SUPPORTED
					assert_equal M2W4TEST_REAL_ATTACHMENTS_EXPECTED.clone.delete_if{|attachment| attachment == nil}.size, attachments.clone.delete_if{|attachment| attachment == nil}.size
					i = 0
					while i < M2W4TEST_REAL_ATTACHMENTS_EXPECTED.size
						M2W_LOGGER.debug("attachment index: #{i}")

						if M2W4TEST_REAL_ATTACHMENTS_EXPECTED[i] != nil then
							if /^image/ =~ Mime.new.mime(M2W4TEST_REAL_ATTACHMENTS_EXPECTED[i].filename) then
								if M2W_SYSTEM_RMAGICK_SUPPORTED then
									expected = Magick::Image.from_blob(M2W4TEST_REAL_ATTACHMENTS_EXPECTED[i].content).shift
									actual = Magick::Image.from_blob(attachments[i].content).shift
									assert ImageTestUtils.nearly_identical?(expected, actual)
									assert_equal open(response[:attachment_urls][i + 1]) { |stream| stream.read }, attachments[i].content
									if M2W4TEST_REAL_THUMBNAIL_MESSAGES != nil && M2W4TEST_REAL_THUMBNAILS_SCALE != nil && M2W4TEST_REAL_THUMBNAILS_SCALE[i] != nil then
										response = open(response[:thumbnail_urls][i + 1]) { |stream| stream.read }
										if M2W4TEST_REAL_POST_THUMBNAILS_EXPECTED != nil then
											expected = Magick::Image.from_blob(M2W4TEST_REAL_POST_THUMBNAILS_EXPECTED[i].content).shift
											actual = Magick::Image.from_blob(response).shift
											assert ImageTestUtils.nearly_identical?(expected, actual)
										else
											expected = Magick::Image.from_blob(attachments[i].content).shift.scale(M2W4TEST_REAL_THUMBNAILS_SCALE[i])
											actual = Magick::Image.from_blob(response).shift
											assert ImageTestUtils.nearly_identical?(expected, actual)
										end
									end
								else
									M2W_LOGGER.debug("no assert because rmagick not supported")
								end
							else
								assert_equal M2W4TEST_REAL_ATTACHMENTS_EXPECTED[i].content, attachments[i].content
							end
						else
							assert_nil response[:attachment_urls][i + 1]
							assert_nil attachments[i]
						end

						i = i + 1
					end
				end

				# ブログの投稿を確認する
				response = open(link) { |stream| stream.read }.encode(M2W_SYSTEM_INNER_ENCODING, M2W4TEST_WEBLOG_ENCODING, {:invalid => :replace, :undef => :replace})
				assert_match title, response
				assert_match /<!--m2w_version:[0-9]{2}\.[0-9]{2}\.[0-9]{2}--><!--\[wikicontent\] .+? --><!--\[attachment_urls\] 1=.+? -->.+?#{message}.+?/m, response

				M2W_LOGGER.debug("Finish #{self.class.name}#test_attachments")
			end
		end
	end

end
