# coding: UTF-8

#=WordPress ブログの全ての添付ファイルを削除するためのスクリプトです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: delete_files.rb 870 2012-10-31 00:11:22Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# LOAD_PATH に lib フォルダを追加する
$:.unshift(File.dirname(__FILE__) + "/../../lib/")

require 'mechanize'
require 'optparse'
require 'thread_pool'

# 引数を解析する
# デフォルト値を設定する
config = {}
OptionParser.new do |opts|
	# オプション情報を設定する
	opts = OptionParser.new
	opts.on('-h HOMEURL', '--homeurl HOMEURL', '[必須]ホームＵＲＬを指定する。'.encode('Shift_JIS')) do |homeurl|
		config['homeurl'] = homeurl
	end
	opts.on('-u USERNAME', '--username USERNAME', '[必須]ログインユーザ名を指定する。'.encode('Shift_JIS')) do |username|
		config['username'] = username
	end
	opts.on('-p PASSWORD', '--password PASSWORD', '[必須]パスワードを指定する。'.encode('Shift_JIS')) do |password|
		config['password'] = password
	end

	opts.parse!(ARGV)

	# 必須オプションをチェックする
	required = ['homeurl', 'username', 'password']
	for field in required
		if config[field] == nil then
      p config
			puts opts.help
			exit 1
		end
	end
end

agent = Mechanize.new do |agent|
	agent.user_agent_alias = 'Mac Safari'
	agent.follow_meta_refresh = true
	agent.verify_mode = OpenSSL::SSL::VERIFY_NONE
end

agent.get("#{config['homeurl']}/wp-login.php") do |login_page|
	puts "=== moved to login form."

	dashboard_page = login_page.form_with(:name => 'loginform') do |form|
		form.log = config['username']
		form.pwd = config['password']
	end.submit

	puts "=== logined"

	thread_pool = ThreadPool.new(10)
	while true
		medialibrary_page = dashboard_page.link_with(:text => 'メディア').click

		delete_succeeded = false
		medialibrary_page.links_with(:class => 'submitdelete').each do |link|
			thread_pool.run(link) do |link|
				medialibrary_page = link.click
				delete_succeeded = true
				STDOUT.write "."
			end
		end

		break if !delete_succeeded
	end
end

puts
puts "=== finished"
