# coding: UTF-8

require 'plugin/weblog/lib/attachment_media_poster'
require 'plugin/weblog/lib/related_media_poster'
require 'plugin/weblog/lib/standard_command'
require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/lib/weblog_plugin_warning'

#=標準のブログ編集投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_edit.rb 603 2012-03-15 11:41:53Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class StandardEdit_WeblogPlugin < StandardCommand_WeblogPlugin

	def edit(request, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#edit ... endpoint = #{@parent.endpoint}, header = #{request.header.to_s}")

		result = false

		client = @parent.client
		formatter = @parent.formatter
		postid = request.header['postid']

		if postid != nil then
			begin
				blogid = @parent.transform_blogid(blogid) if @parent.respond_to?('transform_blogid')

				before(client, request, blogid, postid, @errors, @warnings)

				vars = {:blogid => blogid, :postid => postid, :encoding => @parent.encoding, M2W_FORMAT_PLUGIN_CONF_HEADER_NAME => request.header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME]}
				vars.merge!(request.header)

				# 書式プラグインの事前処理を行う
				formatter.preset(request, vars, @errors, @warnings)

				# 投稿日付を取得する
				dateCreated = @parent.parse_date(request.header['dateCreated'], Time.now, @errors, @warnings)
				if request.header['dateCreated'] != nil then
					request.header['dateCreated'] = @parent.get_date(dateCreated)
				end

				# ファイル転送の事前準備をする
				media_posters = []
				# 添付ファイルを投稿対象に追加する
				if request.attachments != nil then
					request.attachments.each_with_index do |attachment, i|
						attachment_index = i + 1
						media_name = @parent.get_attachment_filepath(postid, dateCreated, attachment_index, attachment.filename)
						thumbnail_name = @parent.get_thumbnail_filepath(postid, dateCreated, attachment_index, attachment.filename)
						media_posters.push(AttachmentMediaPoster.new(attachment, attachment_index, media_name, thumbnail_name, vars))
					end
				end
				# 関連ファイルを投稿対象に追加する
				if formatter.mode(request) == 'html' && request.related_attachments != nil then
					request.related_attachments.each_with_index do |related_attachment, i|
						related_attachment_index = i + 1
						media_name = "rel#{postid}_#{related_attachment_index}#{File.extname(related_attachment.filename)}"
						thumbnail_name = "relthumbs#{postid}_#{related_attachment_index}#{File.extname(related_attachment.filename)}"
						media_posters.push(RelatedMediaPoster.new(related_attachment, media_name, thumbnail_name, vars))
					end
				end

				# ファイルを転送する
				vars[:attachment_urls] = {}
				vars[:thumbnail_urls] = {}
				vars[:related_attachment_urls] = {}
				vars[:related_thumbnail_urls] = {}
				post_medias(client, @parent.username, @parent.password, blogid, media_posters, @errors, @warnings)


				# 書式変換を行う
				begin
					formatted_contents = nil
					formatted_contents = formatter.format(request, vars, @errors, @warnings)
					request.header.merge!(formatted_contents)
				rescue => e
					M2W_LOGGER.error("ブログ記事の書式変換に失敗しました。")
					M2W_LOGGER.error(e)
					@errors.push(WeblogPluginError.new(
						"書式変換エラー(メッセージ = #{e.message})",
						"ブログ記事の書式変換に失敗しました(メッセージ = #{e.message})。"))
					M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = false")
					return false
				end

				# ブログ記事を編集投稿する
				begin
					edit_article(client, blogid, postid, request.header, dateCreated)
				rescue => e
					M2W_LOGGER.error("ブログ記事の編集に失敗しました。")
					M2W_LOGGER.error(e)
					@errors.push(WeblogPluginError.new(
						"ブログ記事投稿エラー(メッセージ = #{e.message})",
						"ブログ記事の投稿に失敗しました(メッセージ = #{e.message})。"))
					M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = false")
					return false
				end

				@report[:original_content] = request.original_content
				@report[:original_html_content] = request.original_html_content
				@report[:postid] = postid.to_s
				@report[:attachment_urls] = vars[:attachment_urls]
				@report[:thumbnail_urls] = vars[:thumbnail_urls]
				@report[:title] = request.header['title']

				after(client, request, blogid, postid, @errors, @warnings)

				M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = true")
				return true
			rescue => e
				M2W_LOGGER.error("ブログ記事の編集に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"ブログ記事編集エラー(メッセージ = #{e.message})",
					"ブログ記事の編集に失敗しました(メッセージ = #{e.message})。"))
			end
		else
			M2W_LOGGER.error("投稿ＩＤの指定がありません。")
			@errors.push(WeblogPluginError.new(
				"投稿ＩＤ指定不足",
				"投稿ＩＤの指定がありませんでした。"))
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = false")
		return false
	end

	def header_alias
		return M2W_WEBLOG_POST_HEADER_ALIAS
	end

	def before(client, request, blogid, postid, errors, warnings)
	end

	def after(client, request, blogid, postid, errors, warnings)
	end

	def edit_article(client, blogid, postid, header, dateCreated)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

end
