# coding: UTF-8

require 'plugin/weblog/lib/standard_command'
require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/lib/weblog_plugin_warning'

require 'open-uri'

#=標準のブログ記事取得用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_get.rb 610 2012-03-16 23:02:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class StandardGet_WeblogPlugin < StandardCommand_WeblogPlugin

	def get(request)
		M2W_LOGGER.debug("Start  #{self.class.name}#get ... endpoint = #{@parent.endpoint}, header = #{request.header.to_s}")
		result = false

		client = @parent.client
		formatter = @parent.formatter

		postid = request.header['postid']

		before(client, request, postid, @errors, @warnings)

		# ブログ記事を取得する
		description = nil
		begin
			(description, link) = get_article(client, postid)
			@report[:postid] = postid
			@report[:link] = link
		rescue => e
			M2W_LOGGER.error("ブログ記事の取得に失敗しました。")
			M2W_LOGGER.error(e)
			@errors.push(WeblogPluginError.new(
				"ブログ記事取得エラー(メッセージ = #{e.message})",
				"ブログ記事の取得に失敗しました(メッセージ = #{e.message})。"))
			return false
		end

		# ブログ記事情報を解析する
		(version, original_content, original_content_type) = formatter.get_uncommentout_content(description)
		if original_content != nil then
			@report[:original_content] = nil
			@report[:original_html_content] = nil
			case original_content_type
			when 'wiki'
				@report[:original_content] = original_content
			when 'html'
				@report[:original_html_content] = original_content
			end
			result = true
		end
		attachment_urls = formatter.get_uncommentout_attachment_urls_content(description)
		related_attachment_urls = formatter.get_uncommentout_related_attachment_urls_content(description)
		@report[:attachments] = get_attachments(attachment_urls)
		@report[:related_attachments] = get_related_attachments(related_attachment_urls)

		after(client, request, postid, @errors, @warnings)

		M2W_LOGGER.debug("Finish #{self.class.name}#get ... result = #{result}")
		return result
	end

	def get_attachments(urls)
		M2W_LOGGER.debug("Start  #{self.class.name}#get_attachments ... urls = #{urls.to_s}")
		result = []

		urls.each do |index, url|
			begin
				if url != nil then
					open(url, 'rb') do |f|
						attachment_content = f.gets(nil)
						if %r!/([^/]+)$! =~ url then
							attachment_filename = $1
							M2W_LOGGER.debug("attachment ... index = #{index.to_i - 1}, filename = #{attachment_filename}")
							result[index.to_i - 1] = MailAttachment.new(attachment_filename, attachment_content)
						end
					end
				else
					M2W_LOGGER.debug("no attachment ... index = #{index.to_i - 1}")
					result[index.to_i - 1] = nil
				end
			rescue => e
				M2W_LOGGER.error("添付ファイルの取得に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"添付ファイル取得エラー(メッセージ = #{e.message})",
					"添付ファイルの取得に失敗しました(メッセージ = #{e.message})。"))
			end
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#get_attachments ... result = #{result.size}")
		return result
	end

	def get_related_attachments(urls)
		M2W_LOGGER.debug("Start  #{self.class.name}#get_related_attachments ... urls = #{urls.to_s}")
		result = []

		urls.each do |content_id, url|
			begin
				if url != nil then
					open(url, 'rb') do |f|
						attachment_content = f.gets(nil)
						if %r!/([^/]+)$! =~ url then
							attachment_filename = $1
							M2W_LOGGER.debug("attachment ... content_id = #{content_id}, filename = #{attachment_filename}")
							result.push(MailAttachment.new(attachment_filename, attachment_content, content_id))
						end
					end
				end
			rescue => e
				M2W_LOGGER.error("添付ファイルの取得に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"添付ファイル取得エラー(メッセージ = #{e.message})",
					"添付ファイルの取得に失敗しました(メッセージ = #{e.message})。"))
			end
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#get_related_attachments ... result = #{result.size}")
		return result
	end

	def header_alias
		return {}
	end

	def before(client, request, postid, errors, warnings)
	end

	def after(client, request, postid, errors, warnings)
	end

	def get_article(client, postid)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

end
