# coding: UTF-8

#=メールの送信テストをするツールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: sendmail.rb 614 2012-03-16 23:54:38Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# LOAD_PATH に lib フォルダを追加する
$:.unshift(File.dirname(__FILE__) + "/../../main/")
$:.unshift(File.dirname(__FILE__) + "/../../main/lib/")

require 'optparse'

# Mail2Weblog のルートパスを設定する
M2W_ROOT_PATH = File.dirname(__FILE__) + "/../../main"

require 'm2w_configurator'
require 'm2w_mail_sender'

# 引数を解析する
# デフォルト値を設定する
config = {}
OptionParser.new do |opts|
	# オプション情報を設定する
	opts = OptionParser.new
	opts.on('-t TO', '--to TO', '[任意]送信先メールアドレスを指定する。') do |to|
		config['mode'] = 'to'
		config['to'] = MailAddress.new(to)
	end
	opts.on('-f FILENAME', '--file FILENAME', '[任意]送信するメールの内容を指定する。') do |filename|
		config['mode'] = 'filename'
		config['filename'] = filename
	end

	opts.parse!(ARGV)

	# 必須オプションをチェックする
	required = ['mode']
	for field in required
		if config[field] == nil then
      p config
			puts opts.help
			exit 1
		end
	end
end

mail_sender = Mail2WeblogMailSender.new(
	M2W_SMTP_SERVER_ADDRESS,
	M2W_SMTP_SERVER_PORT,
	M2W_SMTP_SECURITY_TYPE,
	M2W_SMTP_SERVER_USER,
	M2W_SMTP_SERVER_PASSWORD,
	M2W_POP3_BEFORE_SMTP_SERVER_ADDRESS,
	M2W_POP3_BEFORE_SMTP_SERVER_PORT,
	M2W_POP3_BEFORE_SMTP_SERVER_USER,
	M2W_POP3_BEFORE_SMTP_SERVER_PASSWORD,
	M2W_SUBJECT_HEADER,
	M2W_SUBJECT_SEPARATOR,
	M2W_REPLY_ADDRESS)

mail = nil
case config['mode']
when 'to'
	mail = Mail.new(
		'タイトル',
		MailAddress.new(M2W_REPLY_ADDRESS),
		[config['to']],
		'本文')
when 'filename'
	open(config['filename']) do |file|
		mail = file.read()
	end
end
mail_sender.sendmail(mail)
