# coding: UTF-8

require 'base64'

require 'm2w_common'

#=簡易メール情報取得ユーティリティー（添付ファイル）
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: mailpart.rb 39 2011-06-01 13:51:30Z yutaka_at_home $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MailPart

	attr_reader :header
	attr_reader :body

	def initialize(header, body)
		@header = header
		@body = body
	end

	def filename
		if /name="(.+)"/ =~ @header['Content-Type'] then
			return $1
		else
			return nil
		end
	end

	def decode
		if 'base64' != @header['Content-Transfer-Encoding'] then
			raise EncodingError.new('base64 以外の Content-Transfer-Encoding を持つ添付ファイルはサポートしていません。')
		end

		return Base64::decode64(@body)
	end

end
