# coding: UTF-8

#=Movable Type ̂߂̊gW[łB
#
# ŏ̒:: gDC[
# |Wg:: $Id: mt_post_extension.rb 39 2011-06-01 13:51:30Z yutaka_at_home $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class MTPostExtension

  def postBefore(postcommand, server)
    @categories = postcommand.attributes[M2W_WEBLOG_MT_CATEGORIES]
    postcommand.attributes.delete(M2W_WEBLOG_MT_CATEGORIES)
  end

  def postAfter(postcommand, server, postid)
    setPostCategories(postcommand, server, postid)
    publishPost(postcommand, server, postid)
  end

  # uOLɃJeSݒ肷
  def setPostCategories(postcommand, server, postid)
    if @categories != nil then
      M2W_LOGGER.info("Start  mt.getCategoryList ... postid = #{postid}, categories = #{@categories}")
      categoryMap = getCategoryMap(server.call("mt.getCategoryList", postcommand.blogid, postcommand.username, postcommand.password))
      M2W_LOGGER.info("Finish mt.getCategoryList ... postid = #{postid}, categoryMap = #{@categoryMap}")

      M2W_LOGGER.info("Start  mt.setPostCategories ... postid = #{postid}, categories = #{@categories}")
      result = server.call(
        "mt.setPostCategories",
        postid, postcommand.username, postcommand.password,
        getCategoryArray(@categories, categoryMap))
      M2W_LOGGER.info("Finish mt.setPostCategories ... postid = #{postid}")
    end
  end

  # uOL̍č\zs
  def publishPost(postcommand, server, postid)
    M2W_LOGGER.info("Start  mt.publishPost ... postid = #{postid}")
    result = server.call("mt.publishPost", postid, postcommand.username, postcommand.password)
    M2W_LOGGER.info("Finish mt.publishPost ... postid = #{postid}")
  end

  def getCategoryMap(categories)
    result = {}
    # JeS̓JeShcɃ}bv
    categories.each do |category|
      result[category['categoryId']] = category['categoryId']
    end

    # JeShc͂̂܂܃JeShcɃ}bv
    #
    # ij
    # ̃JeS}bv쐬̏Ԃ́A
    # JeSɃJeShcƏd݂̂ꍇAJeSD悷ƂƂӖB
    # 炭̓AP[XƎv邪AlԂւ̂킩₷Ƃϓ_炻肷B
    categories.each do |category|
      result[category['categoryName']] = category['categoryId']
    end
    return result
  end

  def getCategoryArray(categories, categoryMap)
    result = []
    categories.split(",").each do |category|
      if categoryMap.has_key?(category) then
        result.push({"categoryId" => categoryMap[category]})
      else
        # ݂ȂJeS͖
      end
    end
    return result
  end

end
