#!/usr/local/bin/ruby
# coding: UTF-8

require 'kconv'

# ŏ̒:: gDC[
# |Wg:: $Id: m2w_common.rb 46 2011-06-07 11:40:08Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)

# R[hϊ
#
# Ruby 1.8.2  Ruby 1.9 ȏ̗T|[g邽߂̊ȈՃ[eBeBłB
def m2w_encode(buffer, to_encoding, from_encoding = nil)
	if RUBY_VERSION >= '1.9.0' then
		return buffer.encode(to_encoding, from_encoding)
	else
		return Kconv.kconv(buffer, m2w_get_encoding(to_encoding), m2w_get_encoding(from_encoding))
	end
end

# GR[h񂩂 Kconv 萔擾
def m2w_get_encoding(encoding)
	if encoding != nil then
		if encoding.downcase == 'utf-8' then
			return Kconv::UTF8
		elsif encoding.downcase == 'iso-2022-jp' then
			return Kconv::JIS
		end
	end

	return nil
end
