# coding: UTF-8

#=dumpmail ツールでファイルにダンプしたメールを Mail クラスで解析可能かどうかを試すツールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# LOAD_PATH に lib フォルダを追加する
$:.unshift(File.dirname(__FILE__) + "/../../main/lib/")

require 'fileutils'
require 'optparse'

require 'mail'

# 引数を解析する
# デフォルト値を設定する
DEFAULT_DIRECTORY = '../dumpmail/dump/'
config = {'directory' => DEFAULT_DIRECTORY, 'outdir' => 'parse/'}
OptionParser.new do |opts|
	# オプション情報を設定する
	opts = OptionParser.new
	opts.on('-f FILE', '--file FILENAME', '[必須]解析対象となるファイルを指定する。') {|filename| config['filename'] = filename}
	opts.on('-d DIRECTORY', '--dir DIRECTORY', "[任意]解析対象となるファイルが存在するフォルダを指定する。指定しなかった場合は、#{DEFAULT_DIRECTORY} とする。") {|directory| config['directory'] = directory}
	opts.on('-e ENCODING', '--encoding ENCODING', "[任意]解析対象となるファイルが存在するフォルダを指定する。指定しなかった場合は、#{DEFAULT_DIRECTORY} とする。") {|encoding| config['encoding'] = encoding}
	opts.on('-o OUTDIR', '--outdir OUTDIR', '[任意]ダンプ結果の出力先フォルダを指定する。') {|outdir| config['outdir'] = outdir}
	opts.on('--debug', '[任意]デバッグ情報を標準エラー出力に出力する場合に指定する。指定しなかった場合は dump ふぉデフォルトとする。') {config['debug'] = true}

	opts.parse!(ARGV)

	# 必須オプションをチェックする
	required = ['filename', 'directory']
	for field in required
		if config[field] == nil then
      p config
			puts opts.help
			exit 1
		end
	end
end

FileUtils.makedirs(config['outdir'])

mailfile = File.open("#{config['directory']}#{config['filename']}", "r")
buffer = mailfile.read
mailfile.close

puts "== MAIL CONTENTS =="
puts buffer

mail = Mail.new(buffer)

# メールの本文を出力する
mainfile = File.open("#{config['outdir']}mainfile.txt", "w")

mainfile.puts "== ANALYZED HEADER =="
mail.header_keys.each do |key|
  mainfile.puts "#{key} => #{mail.header(key)}"
end

mainfile.puts "== ANALYZED BODY =="
if config['encoding'] != nil then
  mainfile.puts mail.body(config['encoding'])
else
  mainfile.puts mail.body()
end
mainfile.close

# 添付ファイルを出力する
i = 1
mail.attachments.each do |mailpart|
	puts "attachment: #{mailpart.filename}"
	attachfile = File.open("#{config['outdir']}#{mailpart.filename}", "wb")
	attachfile.write(mailpart.decode64)
	attachfile.close

	attachfile = File.open("#{config['outdir']}attachment#{i}.txt", "w")
	attachfile.write(mailpart.body)
	attachfile.close
end
