# coding: UTF-8

# Mail2Weblog へのコマンドであることを判断するために使われる
# メールタイトルのヘッダー文字列を指定します。
# ここに指定した文字列がメールタイトルにあることを Mail2Weblog は検知して動作します。
# 例）m2w
M2W_SUBJECT_HEADER = 'm2w'

# ブログへの投稿を行うコマンドであることを判断するために使われる
# メールタイトルのヘッダー文字列を指定します。
# ここに指定した文字列がメールタイトルにあることを Mail2Weblog は検知して動作します。
# ブログに投稿する際に期待されるメールタイトルのフォーマットは以下の通りです。
#
# M2W_SUBJECT_HEADER:M2W_POST_COMMAND:ブログID
M2W_POST_COMMAND = 'post'

# ブログへの投稿時に使用するヘッダー名称に使いやすさを考慮した短縮系の別名を定義します。
#
# ブログへの投稿を行う際、メール本文のヘッダーでブログのタイトルや投稿日付などの情報を指定します。
# 形式は、以下の通りです。
#
# ヘッダー１名:ヘッダー１値（例：title:今日は良い一日でした。）
# ヘッダー２名:ヘッダー２値（例：dateCreated:20110330T12:30:00）
# ... 以下、空行までヘッダーの指定が可能 ...
#
# ブログ記事本文
#
# これらのヘッダーの名称は、content 構造体に由来します（「description＝ブログ記事の本文」を除く）。
# エイリアス
M2W_POST_COMMAND_HEADER_ALIAS = {
  'tit' => 'title',
  'dat' => 'dateCreated',
}

# XML-RPC を送信する際のデフォルトのエンコードです。
M2W_XMLRPC_ENCODING = 'UTF-8'
