# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

require 'net/http'

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'accessor'
require 'm2w_configurator'
require 'm2w_mail_parser'
require 'conf/setting'
require 'mailutils/mail_processor'

require 'minitest/unit'

MiniTest::Unit.autorun

#=添付画像を貼り付けるプラグイン Img_plugin のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_img_plugin.rb 105 2011-06-27 12:23:00Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestWeblogPostCommand < MiniTest::Unit::TestCase

	if REAL_M2W_TEST then
		def test_img
			(weblog_host, weblog_address) = Accessor.separate_host_address(M2W_WEBLOG_BASE_URL[WEBLOG_BLOG_ID])
			assert weblog_host != nil
			assert weblog_address != nil

			# メールを送信する
			from_address = MailAddress.new(SMTP_SERVER_MAILADDRESS)
			to_addresses = [MailAddress.new(POP3_SERVER_MAILADDRESS)]
			keyword = Time.now.asctime
			title = "タイトルテスト(#{keyword})"
			message = "コンテンツテスト(#{keyword}){{img}}(#{keyword})"
content = <<"END_CONTENT"
tit:#{title}

#{message}
END_CONTENT
			attachments = [MailProcessor.load_attachment("#{ROOT_PATH}/data/information.png")]
			mail = Mail.new("m2w:post:#{WEBLOG_BLOG_ID}", from_address, to_addresses, content, attachments)

			command = WeblogPostCommand.new
			(header, content, attachments) = Mail2WeblogMailParser.new(M2W_POST_COMMAND_HEADER_ALIAS).parse(mail, WEBLOG_ENCODING)
			assert command.run(M2W_WEBLOG_EXTENSION, from_address, to_addresses, header, content, attachments, WEBLOG_BLOG_ID, nil)
			assert command.report[:postid] != nil
			assert command.report[:attachment_urls] != nil
			assert_equal 1, command.report[:attachment_urls].size
			filepath = "#{M2W_WEBLOG_EXTENSION.get_attachment_filepath(command.report[:postid], 1, attachments[0].filename)}".gsub(".", "\.")
			assert_match /#{filepath}$/, command.report[:attachment_urls][1]
			response = Accessor.access_url(command.report[:attachment_urls][1])
			assert_equal response, attachments[0].content

			response = Accessor.access(weblog_host, weblog_address, WEBLOG_ENCODING)
			assert_match title.encode(WEBLOG_ENCODING), response
			expected_message = %r!コンテンツテスト\(#{keyword}\)<img src="(.+)" />\(#{keyword}\)!
			if /#{expected_message}/ =~ response.encode('UTF-8') then
				imgsrc = $1
				assert_equal command.report[:attachment_urls][1], imgsrc
			else
				assert false
			end
		end
	end

end
