# coding: UTF-8

require 'plugin/weblog/metaweblog/metaweblog_extension'
require 'plugin/weblog/mt/mt_post_extension'

M2W_WEBLOG_MT_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_MT_ATTACHMENT_ROOT_PATH = 'attachments/'
M2W_WEBLOG_MT_CATEGORIES = 'categories'

#=Movable Type のための拡張モジュールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: mt_extension.rb 102 2011-06-27 11:08:50Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MTExtension < MetaWeblogExtension

	attr_reader :host
	attr_reader :address
	attr_reader :username
	attr_reader :password
	attr_reader :encoding
	attr_reader :attachment_root_path

	def initialize(host = M2W_WEBLOG_HOST, address = M2W_WEBLOG_ADDRESS, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_WEBLOG_MT_DEFAULT_ENCODING, attachment_root_path = M2W_WEBLOG_MT_ATTACHMENT_ROOT_PATH)
		super

		# ヘッダーの別名を追加する
		M2W_POST_COMMAND_HEADER_ALIAS['keys'] = 'mt_keywords'
		M2W_POST_COMMAND_HEADER_ALIAS['tags'] = 'mt_tags'
		M2W_POST_COMMAND_HEADER_ALIAS['cats'] = M2W_WEBLOG_MT_CATEGORIES
	end

	# 添付ファイルのパスを取得する
	def get_attachment_filepath(postid, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}/#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# ブログへ投稿する際の拡張モジュールを取得する
	def newPostExtension()
		return MTPostExtension.new(self)
	end

end
