# coding: UTF-8

require 'open-uri'
require 'rexml/document'

require 'rsd/rsd'

#=RSD(Really Simple Discovery) プロセッサ
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: rsd_processor.rb 112 2011-06-30 12:45:45Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class RSDProcessor

	def RSDProcessor.parse(content)
		document = REXML::Document.new(content)
		result = nil
		document.elements.each("rsd/service/") do |element|
			result = RSD.new(
				element.elements['engineName'].text,
				element.elements['engineLink'].text,
				element.elements['homePageLink'].text
			)
		end
		document.elements.each("rsd/service/apis/api") do |element|
			result.set_api(
				element.attribute('name').value,
				element.attribute('preferred').value == 'true',
				element.attribute('apiLink').value,
				element.attribute('blogID').value
			)
		end
		return result
	end

	def RSDProcessor.get_uri(content)
		if %r!type="application/rsd+xml".+?href="(.+?)"! =~ content then
			return $1
		end

		return nil
	end

end
