# coding: UTF-8

require 'plugin/weblog/metaweblog/metaweblog_post_extension'

M2W_META_WEBLOG_DEFAULT_ENCODING = 'UTF-8'
M2W_META_WEBLOG_ATTACHMENT_ROOT_PATH = 'attrs'

#=metaWeblog API を使った標準の拡張モジュールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogExtension

	attr_reader :host
	attr_reader :address
	attr_reader :username
	attr_reader :password
	attr_reader :encoding
	attr_reader :attachment_root_path

	def initialize(host = M2W_WEBLOG_HOST, address = M2W_WEBLOG_ADDRESS, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_META_WEBLOG_DEFAULT_ENCODING, attachment_root_path = M2W_META_WEBLOG_ATTACHMENT_ROOT_PATH)
		@host = host
		@address = address
		@username = username
		@password = password
		@encoding = encoding
		@attachment_root_path = attachment_root_path
	end

	def server
		return XMLRPC::Client.new(host, address)
	end

	# 添付ファイルのパスを取得する
	def get_attachment_filepath(postid, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# ブログへ投稿する際の拡張モジュールを取得する
	def newPostExtension()
		return MetaWeblogPostExtension.new(self)
	end

end
