# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'm2w_mail_parser'
require 'mailutils/mail_processor'

require 'minitest/unit'

MiniTest::Unit.autorun

#=Mail2WeblogMailParser のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_m2w_mail_parser.rb 126 2011-07-20 10:51:49Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestMail2WeblogMailParser < MiniTest::Unit::TestCase

	def test_parse_header
		parser = Mail2WeblogMailParser.new(M2W_SUBJECT_HEADER, M2W_SUBJECT_SEPARATOR_REGEX, M2W_POST_COMMAND_HEADER_ALIAS)

		# .
		mail = Mail.new("m.abc.def", nil, nil, nil, nil)
		result = parser.parse_header(mail, "UTF-8")
		assert_equal 2, result.size
		assert_equal 'abc', result[0]
		assert_equal 'def', result[1]

		# :
		mail = Mail.new("m:abc:def", nil, nil, nil, nil)
		result = parser.parse_header(mail, "UTF-8")
		assert_equal 2, result.size
		assert_equal 'abc', result[0]
		assert_equal 'def', result[1]

		# /
		mail = Mail.new("m/abc/def", nil, nil, nil, nil)
		result = parser.parse_header(mail, "UTF-8")
		assert_equal 2, result.size
		assert_equal 'abc', result[0]
		assert_equal 'def', result[1]
	end

	def test_parse_header_without_header
		parser = Mail2WeblogMailParser.new(nil, M2W_SUBJECT_SEPARATOR_REGEX, M2W_POST_COMMAND_HEADER_ALIAS)

		# .
		mail = Mail.new("abc.def", nil, nil, nil, nil)
		result = parser.parse_header(mail, "UTF-8")
		assert_equal 2, result.size
		assert_equal 'abc', result[0]
		assert_equal 'def', result[1]
	end

	def test_parse_header_without_param
		parser = Mail2WeblogMailParser.new(M2W_SUBJECT_HEADER, M2W_SUBJECT_SEPARATOR_REGEX, M2W_POST_COMMAND_HEADER_ALIAS)

		# .
		mail = Mail.new("m.abc", nil, nil, nil, nil)
		result = parser.parse_header(mail, "UTF-8")
		assert_equal 2, result.size
		assert_equal 'abc', result[0]
		assert_equal '', result[1]
	end

	def test_parse_header_without_header_and_param
		parser = Mail2WeblogMailParser.new(nil, M2W_SUBJECT_SEPARATOR_REGEX, M2W_POST_COMMAND_HEADER_ALIAS)

		# .
		mail = Mail.new("abc", nil, nil, nil, nil)
		result = parser.parse_header(mail, "UTF-8")
		assert_equal 2, result.size
		assert_equal 'abc', result[0]
		assert_equal '', result[1]
	end

	def test_parse_body
		parser = Mail2WeblogMailParser.new(M2W_SUBJECT_HEADER, M2W_SUBJECT_SEPARATOR_REGEX, M2W_POST_COMMAND_HEADER_ALIAS)

		# .
		mail = Mail.new(nil, nil, nil, "tit.abc\n\ndef", [])
		result = parser.parse_body(mail, {}, "UTF-8")
		assert_equal 3, result.size
		assert_equal 1, result[0].size
		assert_equal 'title', result[0].keys[0]
		assert_equal 'abc', result[0]['title']
		assert_equal 'def', result[1]
		assert_equal 0, result[2].size

		# :
		mail = Mail.new(nil, nil, nil, "tit:abc\n\ndef", [])
		result = parser.parse_body(mail, {}, "UTF-8")
		assert_equal 3, result.size
		assert_equal 1, result[0].size
		assert_equal 'title', result[0].keys[0]
		assert_equal 'abc', result[0]['title']
		assert_equal 'def', result[1]
		assert_equal 0, result[2].size

		# /
		mail = Mail.new(nil, nil, nil, "tit/abc\n\ndef", [])
		result = parser.parse_body(mail, {}, "UTF-8")
		assert_equal 3, result.size
		assert_equal 1, result[0].size
		assert_equal 'title', result[0].keys[0]
		assert_equal 'abc', result[0]['title']
		assert_equal 'def', result[1]
		assert_equal 0, result[2].size
	end

	def test_parse_body_header_alias_plus
		parser = Mail2WeblogMailParser.new(M2W_SUBJECT_HEADER, M2W_SUBJECT_SEPARATOR_REGEX, M2W_POST_COMMAND_HEADER_ALIAS)

		mail = Mail.new(nil, nil, nil, "a.value1\nb.value2\ndef", [])
		result = parser.parse_body(mail, {"b" => "c"}, "UTF-8")
		assert_equal 3, result.size
		assert_equal 2, result[0].size
		assert_equal 'value1', result[0]['a']
		assert_equal 'value2', result[0]['c']
	end

end
