# coding: UTF-8

require 'style/hikidoc/hikidoc'

require 'cgi'

M2W_FORMATTER_MARK_VERSION = "m2w_version"
M2W_FORMATTER_MARK_WIKICONTENT = "wikicontent"
M2W_FORMATTER_MARK_ATTACHMENT_URLS = "attachment_urls"
M2W_FORMATTER_COMMENTOUT_REGEX = /^(<!--#{M2W_FORMATTER_MARK_VERSION}:[0-9]{2}\.[0-9]{2}\.[0-9]{2}-->)?(<!--\[#{M2W_FORMATTER_MARK_WIKICONTENT}\] .+? -->)?(<!--\[#{M2W_FORMATTER_MARK_ATTACHMENT_URLS}\] .+? -->)?(<!-- .+? -->)?/m

#=本文のフォーマット変換を行います。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: formatter.rb 204 2011-08-12 01:34:55Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Formatter

	attr_reader :has_plugin_content
	attr_reader :warnings
	attr_reader :errors

	def initialize(plugin_manager)
		@plugin_manager = plugin_manager
	end

	def preformat(content, content_with_header, has_attachments)
		@warnings = []
		@errors = []

		result = HikiDoc.to_xhtml(content, M2W_HIKI_OPTIONS).chomp.encode(M2W_SYSTEM_INNER_ENCODING)

		@has_plugin_content = (%r!<(div|span) class="plugin">{{(.+)\}\}</(div|span)>! =~ result)
		@commentout_content = get_commentout_content(content_with_header).encode(M2W_SYSTEM_INNER_ENCODING)

		if @has_plugin_content || has_attachments then
			return result
		else
			return @commentout_content + result
		end
	end

	def postformat(content, vars)
		formated_content = ""

		# プラグインを処理する
		contents = content.split(/\r\n|\r|\n/)
		contents.each do |line|
			if /<(div|span) class="plugin">/ =~ line then
				plugin_type = $1

				case plugin_type
				when "div"
					if %r!<div class="plugin">{{(.+)\}\}</div>! =~ line then
						plugin_content = $1
						begin
							formated_content << call_plugin_contents(plugin_content, vars)
						rescue FormatPluginWarning => warning
							formated_content << "{{警告: #{warning.content}}}"
							@warnings.push(warning)
						rescue FormatPluginError => error
							formated_content << "{{エラー: #{error.content}}}"
							@errors.push(error)
						end
					end
				when "span"
					while 0 < line.length
						if %r!^(.*?)<span class="plugin">{{(.+?)\}\}</span>(.*)$! =~ line then
							left = $1
							plugin_content = $2
							right = $3

							begin
								formated_content << left + call_plugin_contents_inline(plugin_content, vars)
							rescue FormatPluginWarning => warning
								formated_content << left + "{{警告: #{warning.content}}}"
								@warnings.push(warning)
							rescue FormatPluginError => error
								formated_content << left + "{{エラー: #{error.content}}}"
								@errors.push(error)
							end
							line = right
						else
							formated_content << line
							break
						end
					end
				end
			else
				formated_content << line + "\n"
			end
  	end

		# 添付ファイルがある場合は、添付ファイルの情報も埋め込む
		commentout_attachment_urls_content = ""
		if vars[:attachment_urls] != nil then
			commentout_attachment_urls_content = get_commentout_attachment_urls_content(vars[:attachment_urls])
		end

		return @commentout_content + commentout_attachment_urls_content + formated_content.chomp
	end

	def call_plugin_contents(content, vars)
		begin
			if /^ *([a-zA-Z_][0-9a-zA-Z_]*) *$/ =~ content then
				plugin_name = $1
				param = nil
			elsif /^ *([a-zA-Z_][0-9a-zA-Z_]*) *\((.+)\)$/ =~ content then
				plugin_name = $1
				param =$2
			else
				return "<!-- #{content} -->"
			end

			plugin = @plugin_manager.get_format_plugin(plugin_name)
			if plugin != nil then
				return plugin.plugin_contents(param, vars)
			else
				raise FormatPluginWarning.new("不明なプラグイン指定(プラグイン名 = #{plugin_name})")
			end
		rescue FormatPluginWarning => e
			raise e
		rescue FormatPluginError => e
			raise e
		rescue Exception => e
			M2W_LOGGER.error("プラグイン動作時に例外が発生しました。")
			M2W_LOGGER.error(e)
			raise FormatPluginError.new("プラグイン動作時例外(コンテンツ = #{content})", "プラグイン動作時例外が発生しました（コンテンツ = #{content}）。")
		end
	end

	def call_plugin_contents_inline(content, vars)
		begin
			if /(^[a-zA-Z_][0-9a-zA-Z_]*$)/ =~ content then
				plugin_name = $1
				param = nil
			elsif /^([a-zA-Z_][0-9a-zA-Z_]*)\((.+)\)$/ =~ content then
				plugin_name = $1
				param = $2
			else
				return "<!-- #{content} -->"
			end

			plugin = @plugin_manager.get_format_plugin($1)
			if plugin != nil then
				return plugin.plugin_contents_inline(param, vars)
			else
				raise FormatPluginWarning.new("不明なプラグイン指定(プラグイン名 = #{plugin_name})")
			end
		rescue FormatPluginWarning => e
			raise e
		rescue FormatPluginError => e
			raise e
		rescue Exception => e
			M2W_LOGGER.error("プラグイン動作時に例外が発生しました。")
			M2W_LOGGER.error(e)
			raise FormatPluginError.new("プラグイン動作時例外(コンテンツ = #{content})", "プラグイン動作時例外が発生しました（コンテンツ = #{content}）。")
		end
	end

	def escape(content)
		return CGI.escapeHTML(content)
	end

	def unescape(content)
		return CGI.unescapeHTML(content)
	end

	def get_commentout_content(content_with_header)
		return "<!--#{M2W_FORMATTER_MARK_VERSION}:#{M2W_VERSION}--><!--[#{M2W_FORMATTER_MARK_WIKICONTENT}] #{escape(content_with_header)} -->"
	end

	def get_commentout_attachment_urls_content(attachment_urls)
		result = "<!--[attachment_urls] "
		attachment_urls.each do |index, attachment_url|
			result << "#{index}=#{attachment_url}"
			if index != attachment_urls.size then
				result << ','
			end
		end
		result << " -->"
	end

	def get_uncommentout_content(content)
		M2W_LOGGER.debug("Start  #{self.class.name}#get_uncommentout_content")

		result_version = nil
		result_wikicontent = nil
		if M2W_FORMATTER_COMMENTOUT_REGEX =~ content then
			version = $1
			wikicontent = $2
			old_wikicontent = $4
			M2W_LOGGER.debug("match ... version = #{version}, wikicontent = #{wikicontent}, old_wikicontent = #{old_wikicontent}")

			if version != nil && wikicontent != nil then
				if /^<!--#{M2W_FORMATTER_MARK_VERSION}:([0-9]{2}\.[0-9]{2}\.[0-9]{2})-->$/ =~ version then
					result_version = $1
				end

				if /^<!--\[#{M2W_FORMATTER_MARK_WIKICONTENT}\] (.+?) -->$/m =~ wikicontent then
					result_wikicontent = unescape($1)
					result = true
				end
			elsif old_wikicontent != nil then
				M2W_LOGGER.debug('old_wikicontent != ""')
				if /^<!-- *(.+?) *-->$/m =~ old_wikicontent then
					result_wikicontent = unescape($1)
					M2W_LOGGER.debug("match old_wikicontent ... #{$1}")
					result = true
				else
					M2W_LOGGER.debug('no match old_wikicontent')
				end
			end
		else
			M2W_LOGGER.debug("no match")
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#get_uncommentout ... version = #{result_version}, wikicontent = #{result_wikicontent}")
		return [result_version, result_wikicontent]
	end

	def get_uncommentout_attachment_urls_content(content)
		M2W_LOGGER.debug("Start  #{self.class.name}#get_uncommentout_attachment_urls_content")

		result = {}
		if M2W_FORMATTER_COMMENTOUT_REGEX =~ content then
			attachment_urls = $3
			M2W_LOGGER.debug("match ... version = attachment_urls = #{attachment_urls}")

			if /^<!--\[#{M2W_FORMATTER_MARK_ATTACHMENT_URLS}\] (.+?) -->$/ =~ attachment_urls then
				urls = $1
				while /^([0-9]+?)=([^,]+?)(,[0-9]+?=[^,]+?)*$/ =~ urls
					index = $1.to_s
					url = $2
					urls = $3
					if urls != nil && urls.length > 0 then
						urls = urls.slice(1, urls.length - 1)
					end
					M2W_LOGGER.debug("match ... index = #{index}, url = #{url}, urls = #{urls}")
					result[index] = url
				end
			end
		else
			M2W_LOGGER.debug("no match")
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#get_uncommentout_attachment_urls_content ... result = #{result.to_s}")
		return result
	end

end
