# coding: UTF-8

require 'plugin/format/lib/format_plugin_warning'

#=添付画像を貼り付ける書式プラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: img.rb 194 2011-08-11 13:36:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Img_FormatPlugin

	def plugin_contents(param, vars)
		src_url = get_url(param, vars)

		if src_url != nil then
			return %Q!<div><img src="#{src_url}" /></div>!
		else
			raise FormatPluginWarning.new(
				"画像番号指定ミス(画像番号 = #{param})",
				"画像番号に対応する添付ファイルがありませんでした(画像番号 = #{param})。")
		end
	end

	def plugin_contents_inline(param, vars)
		src_url = get_url(param, vars)

		if src_url != nil then
			return %Q!<img src="#{src_url}" />!
		else
			raise FormatPluginWarning.new(
				"画像番号指定ミス(画像番号 = #{param})",
				"画像番号に対応する添付ファイルがありませんでした(画像番号 = #{param})。")
		end
	end

	def get_url(param, vars)
		attachment_urls = vars[:attachment_urls]

		if attachment_urls != nil then
			if param == nil then
				param = "1"
			end

			if param =~ /^([0-9]*)$/ then
				index = param.to_i
				if attachment_urls.has_key?(index) then
					return attachment_urls[index]
				end
			else
				return nil
			end
		end
	end

end
