# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog'
require 'plugin/weblog/fc2/fc2_post'
require 'plugin/weblog/fc2/fc2_formatter'

M2W_WEBLOG_FC2_HOST = 'blog.fc2.com'
M2W_WEBLOG_FC2_ADDRESS = '/xmlrpc.php'

M2W_WEBLOG_FC2_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_FC2_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_WEBLOG_FC2_XMLRPC_ENCODING = 'UTF-8'

#=FC2 ブログのためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: fc2.rb 194 2011-08-11 13:36:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Fc2_WeblogPlugin < MetaWeblog_WeblogPlugin

	def initialize(host = M2W_WEBLOG_FC2_HOST, address = M2W_WEBLOG_FC2_ADDRESS, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_WEBLOG_FC2_DEFAULT_ENCODING, attachment_root_path = M2W_WEBLOG_FC2_ATTACHMENT_ROOT_PATH)
		super
	end

	def server
		result = XMLRPC::Client.new(host, address)
		result.set_parser(XMLRPCParser.new(M2W_WEBLOG_FC2_XMLRPC_ENCODING))
		return result
	end

	def formatter
		return Fc2Formatter.new(@plugin_manager)
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return Fc2Post_WeblogPlugin.new(self)
	end

end
