# coding: UTF-8

require 'open-uri'
require 'xmlrpc/client'

#=metaWeblog API を使った標準のブログ記事取得用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: meta_weblog_get.rb 194 2011-08-11 13:36:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogGet_WeblogPlugin

	attr_reader :report

	def initialize(parent)
		@parent = parent
		@report = {}
	end

	def header_alias
		return {}
	end

	def get(header, content, attachments, param)
		M2W_LOGGER.debug("Start  #{self.class.name}#get ... http://#{@parent.host}#{@parent.address}, header = #{header.to_s}")
		result = false

		server = @parent.server
		formatter = @parent.formatter

		postid = header['postid']

		before(server, header, content, attachments, param, postid)

		# ブログ記事情報を取得する
		M2W_LOGGER.debug("Start  metaWeblog.getPost ... postid = #{postid}")
		post = server.call("metaWeblog.getPost", postid, @parent.username, @parent.password)
		@report[:link] = post['link']
		M2W_LOGGER.debug("Finish metaWeblog.getPost")

		# ブログ記事情報を解析する
		(version, wikicontent) = formatter.get_uncommentout_content(post['description'])
		if wikicontent != nil then
			@report[:wikicontent] = wikicontent
			result = true
		end
		attachment_urls = formatter.get_uncommentout_attachment_urls_content(post['description'])
		@report[:attachments] = get_attachments(attachment_urls)

		after(server, header, content, attachments, param, postid)

		M2W_LOGGER.debug("Finish #{self.class.name}#get ... result = #{result}")
		return result
	end

	def before(server, header, content, attachments, param, postid)
	end

	def after(server, header, content, attachments, param, postid)
	end

	def get_attachments(urls)
		M2W_LOGGER.debug("Start  #{self.class.name}#get_attachments ... urls = #{urls.to_s}")
		result = []

		urls.each do |index, url|
			open(url, 'rb') do |f|
				attachment_content = f.gets(nil)
				if %r!/([^/]+)$! =~ url then
					attachment_filename = $1
					M2W_LOGGER.debug("attachment_filename ... #{attachment_filename}")
					result.push(MailAttachment.new(attachment_filename, attachment_content))
				end
			end
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#get_attachments ... result = #{result.size}")
		return result
	end

end
