# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog_post'

M2W_WEBLOG_MT_CATEGORIES = 'categories'

#=Movable Type のための投稿用拡張モジュールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: movable_type_post.rb 231 2011-08-21 13:02:19Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MovableTypePost_WeblogPlugin < MetaWeblogPost_WeblogPlugin

	def header_alias
		return {'keys' => 'mt_keywords', 'tags' => 'mt_tags', 'cats' => M2W_WEBLOG_MT_CATEGORIES}
	end

	def before(client, header, content, attachments, blogid)
		@categories = header[M2W_WEBLOG_MT_CATEGORIES]
		header.delete(M2W_WEBLOG_MT_CATEGORIES)
	end

	def after(client, header, content, attachments, blogid, postid)
		set_post_categories(client, blogid, postid, @categories)
		publish_post(client, postid)
	end

	# ブログ記事にカテゴリを設定する
	def set_post_categories(client, blogid, postid, categories)
		if categories != nil then
			M2W_LOGGER.debug("Start  mt.getCategoryList ... categories = #{categories}")
			category_map = get_category_map(client.call("mt.getCategoryList", blogid, @parent.username, @parent.password))
			M2W_LOGGER.debug("Finish mt.getCategoryList ... category_map = #{category_map}")

			M2W_LOGGER.debug("Start  mt.setPostCategories ... categories = #{categories}")
			result = client.call(
				"mt.setPostCategories",
				postid, @parent.username, @parent.password,
				get_category_array(categories, category_map))
			M2W_LOGGER.debug("Finish mt.setPostCategories")
		end
	end

	# ブログ記事の再構築を行う
	def publish_post(client, postid)
		M2W_LOGGER.debug("Start  mt.publishPost ... postid = #{postid}")
		result = client.call("mt.publishPost", postid, @parent.username, @parent.password)
		M2W_LOGGER.debug("Finish mt.publishPost ...")
	end

	def get_category_map(categories)
		result = {}
		# カテゴリ名はカテゴリＩＤにマップする
		categories.each do |category|
			result[category['categoryId']] = category['categoryId']
		end

		# カテゴリＩＤはそのままカテゴリＩＤにマップする
		#
		# （※）
		# このカテゴリマップ作成の順番は、
		# カテゴリ名にカテゴリＩＤと重複するものが存在する場合、カテゴリ名を優先するということを意味する。
		# 恐らくはレアケースと思われるが、人間へのわかりやすさという観点からそう決定する。
		categories.each do |category|
			result[category['categoryName']] = category['categoryId']
		end
		return result
	end

	def get_category_array(categories, category_map)
		result = []
		categories.split(",").each do |category|
			if category_map.has_key?(category) then
				result.push({"categoryId" => category_map[category]})
			else
				# 存在しないカテゴリは無視する
			end
		end
		return result
	end

end
