# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'blogger/blogger'
require 'conf/setting'

require 'minitest/unit'

MiniTest::Unit.autorun

#=RSDProcessor のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test.rb 214 2011-08-18 09:58:21Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestBlogger < MiniTest::Unit::TestCase

	if REAL_TEST then
		def test_get_users_blogs
			client = XMLRPC::Client.new(M2W_WEBLOG_HOST, M2W_WEBLOG_ADDRESS)
			client.set_parser(XMLRPC_PARSER) if XMLRPC_PARSER != nil
			blogger = Blogger.new(client, M2W_WEBLOG_USERNAME, M2W_WEBLOG_PASSWORD, M2W_SYSTEM_INNER_ENCODING)
			result = blogger.get_users_blogs()
			BLOGS.each do |blogid, blog|
				assert_equal blog[0], result[blogid].blogid
				assert_equal blog[1], result[blogid].url
				assert_equal blog[2], result[blogid].blog_name
			end
		end
	end

end
