# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__)) + "/../../m2w"

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'conf/setting'
require 'mailutils/mail_processor'
require 'testutils/accessor'
require 'testutils/mail_testutils'
require 'testutils/weblog_testutils'

require 'minitest/unit'

MiniTest::Unit.autorun

#=添付画像を貼り付ける img 書式プラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_img_plugin.rb 194 2011-08-11 13:36:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestImgFormatPlugin < MiniTest::Unit::TestCase

	def test_contents
		plugin = Img_FormatPlugin.new

		vars = {
			:attachment_urls => {1 => "http://abc.def.ghi/jkl.txt"},
		}
		result = plugin.plugin_contents(nil, vars)
		assert_equal %Q!<div><img src="http://abc.def.ghi/jkl.txt" /></div>!, result

		result = plugin.plugin_contents('1', vars)
		assert_equal %Q!<div><img src="http://abc.def.ghi/jkl.txt" /></div>!, result

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents('0', vars)
		end

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents('2', vars)
		end
	end

	def test_plugin_contents_inline
		plugin = Img_FormatPlugin.new

		vars = {
			:attachment_urls => {1 => "http://abc.def.ghi/jkl.txt"},
		}
		result = plugin.plugin_contents_inline(nil, vars)
		assert_equal %Q!<img src="http://abc.def.ghi/jkl.txt" />!, result

		result = plugin.plugin_contents_inline('1', vars)
		assert_equal %Q!<img src="http://abc.def.ghi/jkl.txt" />!, result

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents_inline('0', vars)
		end

		assert_raises(FormatPluginWarning) do
			result = plugin.plugin_contents_inline('2', vars)
		end
	end

end
