# coding: UTF-8

require 'net/pop'

WAIT_MINITES_FOR_RECEIVING_MAIL = 10

#=[ɊւeXg[eBeB
#
# ŏ̒:: gDC[
# |Wg:: $Id: mail_testutils.rb 188 2011-08-10 03:46:02Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class MailTestUtils

	def initialize(address, port, user, password, encoding)
		@address = address
		@port = port
		@user = user
		@password = password
		@encoding = encoding
	end

	def delete_all()
		# OɃ[{bNXۂɂ
		pop = Net::POP3.new(@address, @port)
		pop.open_timeout = 10
		pop.start(@user, @password)
		pop.each_mail do |m|
			m.delete
		end
		pop.finish
	end

	def get_mail(wait_minites = WAIT_MINITES_FOR_RECEIVING_MAIL)
		mail = nil
		first_time = Time.now.to_i
		while mail == nil
			pop = Net::POP3.new(@address, @port)
			pop.open_timeout = 10
			pop.start(@user, @password)
			pop.each_mail do |m|
				mail = MailProcessor.parse(m.pop, @encoding)
				m.delete
			end
			pop.finish

			# WAIT_MINITES_FOR_RECEIVING_MAIL bo߂ĂMłȂꍇAeXg͎sƂ݂Ȃ
			if Time.now.to_i - first_time >= wait_minites then
				return nil
			end
		end

		return mail
	end

end
