# coding: UTF-8

require 'plugin/format/lib/format_plugin_utils'

#=プラグインマネージャー
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_plugin_manager.rb 308 2011-09-25 08:13:34Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Mail2WeblogPluginManager
	include FormatPluginUtils

	attr_reader :command_plugin_config
	attr_reader :format_plugin_config
	attr_reader :weblog_plugin_config

	def initialize(command_plugin_config = {}, format_plugin_config = {}, weblog_plugin_config = {})
		@command_plugin_config = command_plugin_config != nil ? command_plugin_config : {}
		@format_plugin_config = format_plugin_config != nil ? format_plugin_config : {}
		@weblog_plugin_config = weblog_plugin_config != nil ? weblog_plugin_config : {}
	end

	def get_plugin_name(name)
		while /^(.+)_([a-z])(.+)$/ =~ name
			name = $1 + $2.upcase + $3
		end
		return name.slice(0, 1).upcase + name.slice(1, name.length - 1)
	end

	def get_plugin(name, suffix)
		return eval("#{get_plugin_name(name)}_#{suffix}").new
	end

	def get_command_plugin(name)
		return get_plugin(name, M2W_COMMAND_PLUGIN_SUFFIX)
	end

	def get_format_plugin(name)
		return get_plugin(name, M2W_FORMAT_PLUGIN_SUFFIX)
	end

	def call_format_plugin_preset(name, param, vars)
		plugin = get_format_plugin(name)
		if plugin != nil then
			if plugin.respond_to?("plugin_preset") then
				return plugin.plugin_preset(param, get_format_plugin_vars(name, vars))
			end
		else
			raise FormatPluginWarning.new("不明なプラグイン指定(プラグイン名 = #{plugin_name})")
		end

		return {}
	end

	def call_format_plugin_preset_inline(name, param, vars)
		plugin = get_format_plugin(name)
		if plugin != nil then
			if plugin.respond_to?("plugin_preset_inline") then
				return plugin.plugin_preset_inline(param, get_format_plugin_vars(name, vars))
			end
		else
			raise FormatPluginWarning.new("不明なプラグイン指定(プラグイン名 = #{plugin_name})")
		end

		return {}
	end

	def call_format_plugin_contents(name, param, vars)
		plugin = get_format_plugin(name)
		if plugin != nil then
			if plugin.respond_to?("plugin_contents") then
				return plugin.plugin_contents(param, get_format_plugin_vars(name, vars))
			else
				raise FormatPluginWarning.new("プラグイン定義不正(プラグイン名 = #{plugin_name}, 定義 = plugin_contents)")
			end
		else
			raise FormatPluginWarning.new("不明なプラグイン指定(プラグイン名 = #{plugin_name})")
		end
	end

	def call_format_plugin_contents_inline(name, param, vars)
		plugin = get_format_plugin(name)
		if plugin != nil then
			if plugin.respond_to?("plugin_contents_inline") then
				return plugin.plugin_contents_inline(param, get_format_plugin_vars(name, vars))
			else
				raise FormatPluginWarning.new("プラグイン定義不正(プラグイン名 = #{plugin_name}, 定義 = plugin_contents_inline)")
			end
		else
			raise FormatPluginWarning.new("不明なプラグイン指定(プラグイン名 = #{plugin_name})")
		end
	end

	def get_format_plugin_vars(name, vars)
		result = vars.clone
		set_format_plugin_common_conf(result, @format_plugin_config['COMMON'])
		set_format_plugin_conf(result, @format_plugin_config[name])

		if result[M2W_FORMAT_PLUGIN_CONF_NAME] == nil then
			result[M2W_FORMAT_PLUGIN_CONF_NAME] = {}
		end

		result[M2W_FORMAT_PLUGIN_CONF_NAME][M2W_FORMAT_PLUGIN_NAME] = name

		return result
	end

	def get_weblog_plugin(name)
		return get_plugin(name, M2W_WEBLOG_PLUGIN_SUFFIX)
	end

	def get_weblog_filepath(url_type, postid, date, attachment_index, attachment_filename, default)
		if @weblog_plugin_config['COMMON'] != nil then
			format = @weblog_plugin_config['COMMON'][url_type]
			if format != nil then
				vars = {}
				vars['${postid}'] = postid.to_s
				vars['${year}'] = date.year.to_s.rjust(2, '0')
				vars['${month}'] = date.month.to_s.rjust(2, '0')
				vars['${day}'] = date.day.to_s.rjust(2, '0')
				vars['${hour}'] = date.hour.to_s.rjust(2, '0')
				vars['${min}'] = date.min.to_s.rjust(2, '0')
				vars['${sec}'] = date.sec.to_s.rjust(2, '0')
				vars['${index}'] = attachment_index.to_s
				vars['${filename}'] = attachment_filename.to_s
				vars['${filename_basename}'] = File.basename(attachment_filename, '.*')
				vars['${filename_extname}'] = File.extname(attachment_filename)

				result = format
				vars.each do |key, value|
					result = result.gsub(key, value)
				end

				return result
			end
		end

		return default
	end

end
