# coding: UTF-8

require 'plugin/weblog/lib/standard_command'
require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/meta_weblog/lib/meta_weblog_post_common'

#=metaWeblog API を使った標準のブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: metaweblog_post_extension.rb 132 2011-08-06 00:33:02Z yutaka_at_home $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogPost_WeblogPlugin < StandardCommand_WeblogPlugin
	include MetaWeblogPostCommon

	def header_alias
		return M2W_META_WEBLOG_POST_HEADER_ALIAS
	end

	def post(original_content, header, content, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#post ... endpoint = #{@parent.endpoint}, blogid = #{blogid}, header = #{header.to_s}")

		client = @parent.client
		formatter = @parent.formatter
		@errors = []
		@warnings = []

		before(client, header, content, attachments, blogid)
		vars = {:blogid => blogid, :encoding => @parent.encoding, M2W_FORMAT_PLUGIN_CONF_HEADER_NAME => header[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME]}

		# 事前フォーマットする
		begin
			(preformat_contents, preformat_errors, preformat_warnings) = formatter.preformat(
				content,
				original_content,
				vars,
				attachments != nil && !attachments.empty?)
			header['description'] = preformat_contents
			M2W_LOGGER.debug("pre description ... #{header['description']}")
			@errors.concat(preformat_errors)
			@warnings.concat(preformat_warnings)
		rescue => e
			M2W_LOGGER.error("ブログ記事の事前書式変換に失敗しました。")
			M2W_LOGGER.error(e)
			@errors.push(WeblogPluginError.new(
				"事前書式変換エラー(メッセージ = #{e.message})",
				"ブログ記事の事前書式変換に失敗しました(メッセージ = #{e.message})。"))
			return false
		end

		# 投稿日付を取得する
		if header['dateCreated'] != nil then
			dateCreated = @parent.parse_date(header['dateCreated'])
			header['dateCreated'] = @parent.get_date(dateCreated)
		else
			dateCreated = Time.now
		end

		# ブログ記事を投稿する
		begin
			M2W_LOGGER.debug("Start  metaWeblog.newPost ... header = #{header.to_s}")
			postid = client.call("metaWeblog.newPost", blogid, @parent.username, @parent.password, get_header_for_post(header), 1)
			@report[:postid] = postid
			M2W_LOGGER.debug("Finish metaWeblog.newPost ... postid = #{postid}")
		rescue => e
			M2W_LOGGER.error("ブログ記事の投稿に失敗しました。")
			M2W_LOGGER.error(e)
			@errors.push(WeblogPluginError.new(
				"ブログ記事投稿エラー(メッセージ = #{e.message})",
				"ブログ記事の投稿に失敗しました(メッセージ = #{e.message})。"))
			return false
		end

		# 添付ファイルを投稿する
		(attachment_urls, thumbnail_urls) = post_attachments(client, @parent.username, @parent.password, blogid, postid, header, vars, attachments, dateCreated, @errors, @warnings)
		@report[:attachment_urls] = attachment_urls
		@report[:thumbnail_urls] = thumbnail_urls

		# 事後フォーマットをして、ブログ記事を編集投稿する
		# ※ 編集投稿する理由は、以下の２つ。
		# １．一度投稿しないと postid をプラグインに伝えられないから。postid を使うプラグインを想定している。
		# ２．添付ファイルの URL も postid に依存するから。添付ファイルの URL をのちのち取得できるように保存しておく。
		# いずれの理由も一度投稿しないと確定しない postid に依存する点で共通している。
		if formatter.has_plugin_content || attachment_urls != nil then
			vars = {:postid => postid}
			vars = vars.merge(header)
			vars[:attachment_urls] = attachment_urls
			vars[:thumbnail_urls] = thumbnail_urls

			begin
				(postformat_contents, postformat_errors, postformat_warinings) = formatter.postformat(header['description'], vars)
				header['description'] = postformat_contents
				M2W_LOGGER.debug("post description ... #{header['description']}")
				@errors.concat(postformat_errors)
				@warnings.concat(postformat_warinings)

				begin
					M2W_LOGGER.debug("Start  metaWeblog.editPost ...")
					edit_result = client.call("metaWeblog.editPost", postid, @parent.username, @parent.password, get_header_for_post(header), 1)
					@report[:edit_result] = edit_result
					M2W_LOGGER.debug("Finish metaWeblog.editPost ... result = #{edit_result}")
				rescue => e
					M2W_LOGGER.error("ブログ記事の書式変換後の投稿に失敗しました。")
					M2W_LOGGER.error(e)
					@errors.push(WeblogPluginError.new(
						"書式変換後ブログ記事投稿エラー(メッセージ = #{e.message})",
						"ブログ記事の書式変換後の投稿に失敗しました(メッセージ = #{e.message})。"))
				end
			rescue => e
				M2W_LOGGER.error("ブログ記事の事前書式変換に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"事後書式変換エラー(メッセージ = #{e.message})",
					"ブログ記事の事前書式変換に失敗しました(メッセージ = #{e.message})。"))
			end
		end

		after(client, header, content, attachments, blogid, postid)

		@report[:title] = header['title']

		M2W_LOGGER.debug("Finish #{self.class.name}#post")

		return true
	end

	def before(client, header, content, attachments, blogid)
	end

	def after(client, header, content, attachments, blogid, postid)
	end

end
