# coding: UTF-8

require 'plugin/weblog/lib/standard_command'

#=はてなダイアリーのためのブログ編集投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_edit.rb 274 2011-09-19 07:32:08Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryEdit_WeblogPlugin < StandardCommand_WeblogPlugin

	def header_alias
		return {}
	end

	def edit(original_content, header, content, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#edit ... endpoint = #{@parent.endpoint}, header = #{header.to_s}")

		result = false

		client = @parent.client
		formatter = @parent.formatter

		postid = header['postid']
		header.delete('postid')

		if postid != nil then
			before(client, header, content, attachments, postid)

			# 事前フォーマットする
			entry_content = formatter.preformat(
				content,
				original_content,
				attachments != nil && !attachments.empty?)

			header = @parent.mail_parser.get_alias_header(header, M2W_HATENA_DIARY_POST_HEADER_ALIAS)

			# ブログ記事を投稿する
			begin
				M2W_LOGGER.debug("Start  AtomPub.update_entry")
				update_entry = Atom::Entry.new(:content => entry_content.encode('BINARY', 'BINARY'))
				update_entry.title = header['title'].encode('BINARY', 'BINARY') if header['title'] != nil
				M2W_LOGGER.debug("entry = #{update_entry.to_s}")
				entry_uri = client.update_entry(@parent.entry_collection_uri + "/" + postid, update_entry)
				@report[:postid] = postid
				@report[:attachment_urls] = nil
				M2W_LOGGER.debug("Finish AtomPub.update_entry ... entry_uri = #{entry_uri}, postid = #{postid}")
			rescue => e
				M2W_LOGGER.error("ブログ記事の編集に失敗しました。")
				M2W_LOGGER.error(e)
				@errors.push(WeblogPluginError.new(
					"ブログ記事投稿エラー(メッセージ = #{e.message})",
					"ブログ記事の投稿に失敗しました(メッセージ = #{e.message})。"))
			end

			after(client, header, content, attachments, postid)
			result = true
		else
			M2W_LOGGER.error("投稿ＩＤの指定がありません。")
			@errors.push(WeblogPluginError.new(
				"投稿ＩＤ指定不足(メッセージ = #{e.message})",
				"投稿ＩＤの指定がありませんでした(メッセージ = #{e.message})。"))
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = #{result}")
		return result
	end

	def before(client, header, content, attachments, postid)
	end

	def after(client, header, content, attachments, postid)
	end

end
