# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'm2w_plugin_manager'

require 'time'
require 'minitest/unit'

MiniTest::Unit.autorun

#=Mail2WeblogPluginManager のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_m2w_plugin_manager.rb 306 2011-09-25 07:07:15Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestMail2WeblogPluginManager < MiniTest::Unit::TestCase
	include FormatPluginUtils

	def test_command_plugin
		plugin_manager = Mail2WeblogPluginManager.new

		command = plugin_manager.get_command_plugin('post')
		assert_instance_of Post_CommandPlugin, command
	end

	def test_format_plugin
		plugin_manager = Mail2WeblogPluginManager.new

		format = plugin_manager.get_format_plugin('img')
		assert_instance_of Img_FormatPlugin, format

		format = plugin_manager.get_format_plugin('nico')
		assert_instance_of Nico_FormatPlugin, format
	end

	def test_get_format_plugin_vars
		plugin_manager = Mail2WeblogPluginManager.new
		result = plugin_manager.get_format_plugin_vars('example', {})
		assert_equal 1, result.size
		assert_equal 'example', result[M2W_FORMAT_PLUGIN_CONF_NAME][M2W_FORMAT_PLUGIN_NAME]

		plugin_manager = Mail2WeblogPluginManager.new({}, 
			{
				'COMMON' => {
					'common1' => 'value1',
				},
				'example' => {
					'attr1' => 'value1',
				},
			},
		{})
		result = plugin_manager.get_format_plugin_vars('example', {})
		assert_equal 2, result.size
		assert_equal 'value1', result[M2W_FORMAT_PLUGIN_COMMON_CONF_NAME]['common1']
		assert_equal 'value1', result[M2W_FORMAT_PLUGIN_CONF_NAME]['attr1']
		assert_equal 'example', result[M2W_FORMAT_PLUGIN_CONF_NAME][M2W_FORMAT_PLUGIN_NAME]
	end

	def test_weblog_plugin
		plugin_manager = Mail2WeblogPluginManager.new

		weblog = plugin_manager.get_weblog_plugin('movable_type')
		assert_instance_of MovableType_WeblogPlugin, weblog

		weblog = plugin_manager.get_weblog_plugin('word_press')
		assert_instance_of WordPress_WeblogPlugin, weblog

		weblog = plugin_manager.get_weblog_plugin('fc2')
		assert_instance_of Fc2_WeblogPlugin, weblog

		weblog = plugin_manager.get_weblog_plugin('hatena_diary')
		assert_instance_of HatenaDiary_WeblogPlugin, weblog
	end

	def test_get_weblog_filepath
		postid = 9999
		date = Time.parse('2000-01-02T03:04:05')
		index = 6
		filename = 'file.txt'
		default = 'default.txt'

		plugin_manager = Mail2WeblogPluginManager.new()
		assert_equal 'default.txt', plugin_manager.get_weblog_filepath('attachment_url', postid, date, index, filename, default)

		plugin_manager = Mail2WeblogPluginManager.new({}, {},
			{
				'COMMON' => {
					'attachment_url' => '${postid}_${year}_${month}_${day}_${hour}_${min}_${sec}_${index}_${filename}_${filename_basename}_${filename_extname}',
				}
			})
		assert_equal '9999_2000_01_02_03_04_05_6_file.txt_file_.txt',
			plugin_manager.get_weblog_filepath('attachment_url', postid, date, index, filename, default)
	end

end
