#!/usr/bin/ruby -Ku
# encoding: UTF-8

#=テスト結果のサマリーを出力する CGI スクリプト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: view_testresult.cgi 317 2011-10-04 02:46:30Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

ROOT_PATH = File.dirname(File.expand_path(__FILE__))
$:.unshift(ROOT_PATH + "/")

require 'cgi'

require 'view_testresult_conf'

tests = {}
start_time = nil
finish_time = nil

# 結果ファイルを解析する
if File.exist?(TESTRESULT_FILE_STDOUT) then
	open(TESTRESULT_FILE_STDOUT, 'r') do |file|
		while line = file.gets
			if line =~ /^(Start|Finish) running all tests \.\.\. \[(.+)\]$/
				timing = $1
				time = $2
				case timing
				when 'Start'
					start_time = time
				when 'Finish'
					finish_time = time
				end
			elsif line =~ /^([0-9a-zA-Z_]+)#(test[0-9a-zA-Z_]+) *[:=] *([0-9]+\.[0-9]+) *s *[:=] *(.)$/ then
				test_cls = $1
				test_method = $2
				test_sec = $3
				test_result = $4

				if !tests.has_key?(test_cls) then
					tests[test_cls] = {}
				end

				if !tests[test_cls].has_key?(test_method) then
					tests[test_cls][test_method] = {}
				end

				tests[test_cls][test_method]['sec'] = test_sec
				tests[test_cls][test_method]['result'] = test_result
			end
		end
	end
end

# 結果を html で出力する
cgi = CGI.new("html4")
cgi.out() do
	cgi.html() do
		cgi.head() do
			cgi.title{HTML_TITLE} +
			"<META http-equiv='Content-Type' content='text/html; charset=UTF-8' />" +
			((CSS_URL != nil) ? "<LINK rel='stylesheet' href='#{CSS_URL}' type='text/css' />" : '')
		end +
		cgi.body() do
			body = "<h1>#{HTML_TITLE}</h1>"

			# 概要を出力する
			body << "<h2>#{SUMMARY_TITLE}</h2>"

			body << '<div class="summary_time">'
			body << "<table>"
			body << "<tr><th>#{TIME_LABEL_TEST_START_TIME }</th><td>#{(start_time  != nil ? start_time  : TIME_LABEL_UNKNOWN)}</th></tr>"
			body << "<tr><th>#{TIME_LABEL_TEST_FINISH_TIME}</th><td>#{(finish_time != nil ? finish_time : TIME_LABEL_UNKNOWN)}</th></tr>"
			body << "</table>"
			body << '</div>'

			body << '<div class="summary_test_result">'
			body << "<table>"
			body << "<tr><th>#{TABLE_COLUMN_LABEL_TEST_CLASS}</th><th>#{TABLE_COLUMN_LABEL_SUCCESSED_COUNT}</th><th>#{TABLE_COLUMN_LABEL_FAILED_COUNT}</th></tr>"
			tests.keys.sort.each do |test_cls|
				success_count = 0
				fail_count = 0
				body << "<tr>"
				tests[test_cls].keys.each do |test_method|
					if tests[test_cls][test_method]['result'] == '.' then
						success_count = success_count + 1
					else
						fail_count = fail_count + 1
					end
				end
				body << "<td>#{test_cls}</td><td>#{success_count}</td><td>#{fail_count}</td>"
				body << "<tr>"
			end
			body << "</table>"
			body << '</div>'

			# 詳細を出力する
			body << "<h2>#{DETAIL_TITLE}</h2>"

			body << '<div class="detail_test_result">'
			body << "<table>"
			body << "<tr><th>#{TABLE_COLUMN_LABEL_TEST_CLASS}</th><th>#{TABLE_COLUMN_LABEL_TEST_METHOD}</th><th>#{TABLE_COLUMN_LABEL_SEC}</th><th>#{TABLE_COLUMN_LABEL_RESULT}</th></tr>"
			tests.keys.sort.each do |test_cls|
				method_index = 0
				tests[test_cls].keys.sort.each do |test_method|
					body << "<tr>"
					if method_index == 0 then
						body << "<td rowspan='#{tests[test_cls].size}'>#{test_cls}</td>"
					end

					body << "<td>#{test_method}</td><td>#{tests[test_cls][test_method]['sec']}</td>"

					if tests[test_cls][test_method]['result'] == '.' then
						body << "<td>#{RESULT_LABEL_SUCCESED}</td>"
					else
						body << "<td>#{RESULT_LABEL_FAILED}</td>"
					end
					body << "</tr>"

					method_index = method_index + 1
				end
			end
			body << "</table>"
			body << '</div>'

			body
		end
	end
end
