# coding: UTF-8

PERMISIBBLE_ERROR_FREQUENCY = 10

#=HTTP ANZT[
#
# ŏ̒:: gDC[
# |Wg:: $Id: accessor.rb 349 2011-11-07 15:36:47Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class Accessor

	def Accessor.separate_host_address(url)
		if %r!^http://(.+?)(/.*)$! =~ url then
			return [$1, $2]
		else
			return nil
		end
	end

	def Accessor.access_url(url, encoding = nil, permisibble_error_frequency = PERMISIBBLE_ERROR_FREQUENCY, open_timeout = nil, read_timeout = nil)
		(host, address) = Accessor.separate_host_address(url)
		return Accessor.access(host, address, encoding, permisibble_error_frequency, open_timeout, read_timeout)
	end

	def Accessor.access(host, address, encoding = nil, permisibble_error_frequency = PERMISIBBLE_ERROR_FREQUENCY, open_timeout = nil, read_timeout = nil)
		response = nil
		error_frequency = 0
		while response == nil
			begin
				Net::HTTP.start(host) do |http|
					http.open_timeout = open_timeout if open_timeout != nil
					http.read_timeout = read_timeout if read_timeout != nil
					response = http.get(address)
					case response
					when Net::HTTPSuccess
					else
						error_frequency = error_frequency + 1
						response = nil
					end
				end
			rescue Exception => e
				error_frequency = error_frequency + 1
				response = nil
			end

			if error_frequency >= permisibble_error_frequency then
				return nil
			end
		end

		if encoding != nil then
			return response.body.encode(encoding, encoding)
		else
			return response.body
		end
	end

end
