# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'm2w_plugin_manager'
require 'conf/setting'
require 'mailutils/mail_processor'
require 'testutils/accessor'
require 'testutils/mail_testutils'
require 'testutils/weblog_testutils'

require 'minitest/unit'

MiniTest::Unit.autorun

#=mail2weblog のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_final.rb 410 2011-12-05 02:10:29Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestMail2Weblog < MiniTest::Unit::TestCase

	if REAL_M2W_TEST then
		def setup
			@mail_parser = Mail2WeblogMailParser.new(
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR_REGEX,
				{})

			@mail_sender = Mail2WeblogMailSender.new(
				SENDER_SMTP_SERVER_ADDRESS,
				SENDER_SMTP_SERVER_PORT,
				SENDER_SMTP_SECURITY_TYPE,
				SENDER_SMTP_SERVER_USER,
				SENDER_SMTP_SERVER_PASSWORD,
				SENDER_POP3_SERVER_ADDRESS,
				SENDER_POP3_SERVER_PORT,
				SENDER_POP3_SERVER_USER,
				SENDER_POP3_SERVER_PASSWORD,
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR,
				MailProcessor.parse_mail_address(M2W_REPLY_ADDRESS))

			@mail_testutils = MailTestUtils.new(
				SENDER_SMTP_SERVER_ADDRESS,
				SENDER_SMTP_SERVER_PORT,
				SENDER_SMTP_SECURITY_TYPE,
				SENDER_SMTP_SERVER_USER,
				SENDER_SMTP_SERVER_PASSWORD,
				SENDER_POP3_SERVER_ADDRESS,
				SENDER_POP3_SERVER_PORT,
				SENDER_POP3_SERVER_USER,
				SENDER_POP3_SERVER_PASSWORD,
				M2W_SYSTEM_INNER_ENCODING)
			@mail_testutils.delete_all()

			@weblog_testutils = WeblogTestUtils.new(
				@mail_parser,
				@mail_sender,
				Mail2WeblogPluginManager.new(),
				@mail_testutils,
				SENDER_MAILADDRESS)
		end

		def test_real_simple
			# 事前にメールボックスを空っぽにする
			@mail_testutils.delete_all()

			# メールを送信する
			from_address = MailAddress.new(SENDER_MAILADDRESS)
			to_addresses = [MailAddress.new(RECEIVER_MAILADDRESS)]
			keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
			title = "タイトルテスト@#{keyword}"
			message = "コンテンツテスト@#{keyword}"
content = <<"END_CONTENT"
tit.#{title}

#{message}
END_CONTENT
			@mail_sender.sendmail(Mail.new("m.post.#{WEBLOG_BLOG_ID}", from_address, to_addresses, content, []))

			sleep(SLEEP_MINITES_BEFORE_RUNNING_M2W)

			# システムを起動する
			assert system("ruby #{ROOT_PATH}/../../main/m2w.rb")

			# メールの受信を確認する
			mail = @mail_testutils.get_mail()
			assert mail != nil
			assert_equal "m.get.#{WEBLOG_BLOG_ID}", mail.subject
			assert_equal M2W_REPLY_ADDRESS, mail.from_address.address
			assert_equal from_address.name, mail.from_address.name
			assert_equal 1, mail.to_addresses.size
			assert_equal from_address.address, mail.to_addresses[0].address
			(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
			assert mail_header.has_key?('postid')
			assert_equal 0, mail.attachments.size

			# ブログの投稿を確認する
			(get_result, mail, header, content, attachments, link) = @weblog_testutils.get(WEBLOG_BLOG_ID, mail_header['postid'])
			response = Accessor.access_url(link, WEBLOG_ENCODING).encode(M2W_SYSTEM_INNER_ENCODING)
			assert_match title, response
			assert_match message, response
		end

		if REAL_COMPLEX_M2W_TEST then
			def test_real_complex
				# 事前にメールボックスを空っぽにする
				@mail_testutils.delete_all()

				# メールを送信する
				from_address = MailAddress.new(SENDER_MAILADDRESS)
				to_addresses = [MailAddress.new(RECEIVER_MAILADDRESS)]
				keyword = Time.now.strftime("%Yテ%mス%dト%Hマ%Mー%Sク")
				title = "タイトルテスト@#{keyword}"
				message = "コンテンツテスト@#{keyword}"
				content = ""
				content << "tit.#{title}\n"
				if REAL_COMPLEX_M2W_DATE_ACTUAL != nil && REAL_COMPLEX_M2W_DATE_EXPECTED then
					content << "dat.#{REAL_COMPLEX_M2W_DATE_ACTUAL}\n"
				end
				if REAL_COMPLEX_M2W_CATS_ACTUAL != nil && REAL_COMPLEX_M2W_CATS_EXPECTED then
					content << "cats.#{REAL_COMPLEX_M2W_CATS_ACTUAL}\n"
				end
				if REAL_COMPLEX_M2W_KEYS_ACTUAL != nil && REAL_COMPLEX_M2W_KEYS_EXPECTED then
					content << "keys.#{REAL_COMPLEX_M2W_KEYS_ACTUAL}\n"
				end
				if REAL_COMPLEX_M2W_TAGS_ACTUAL != nil && REAL_COMPLEX_M2W_TAGS_EXPECTED then
					content << "tags.#{REAL_COMPLEX_M2W_TAGS_ACTUAL}\n"
				end
				content << "\n"
				content << "#{message}\n"
				@mail_sender.sendmail(Mail.new("m.post.#{WEBLOG_BLOG_ID}", from_address, to_addresses, content, []))

				sleep(SLEEP_MINITES_BEFORE_RUNNING_M2W)

				# システムを起動する
				assert system("ruby #{ROOT_PATH}/../../main/m2w.rb")

				# メールの受信を確認する
				mail = @mail_testutils.get_mail()
				assert mail != nil
				assert_equal "m.get.#{WEBLOG_BLOG_ID}", mail.subject
				assert_equal M2W_REPLY_ADDRESS, mail.from_address.address
				assert_equal from_address.name, mail.from_address.name
				assert_equal 1, mail.to_addresses.size
				assert_equal from_address.address, mail.to_addresses[0].address
				(mail_header, mail_content) = @mail_parser.parse_content(mail.content, {})
				assert mail_header.has_key?('postid')
				assert_equal 0, mail.attachments.size

				# ブログの投稿を確認する
				(get_result, mail, header, content, attachments, link) = @weblog_testutils.get(WEBLOG_BLOG_ID, mail_header['postid'])
				response = Accessor.access_url(link, WEBLOG_ENCODING).encode(M2W_SYSTEM_INNER_ENCODING)
				assert_match title, response
				if REAL_COMPLEX_M2W_DATE_ACTUAL != nil && REAL_COMPLEX_M2W_DATE_EXPECTED then
					assert_match REAL_COMPLEX_M2W_DATE_EXPECTED, response
				end
				if REAL_COMPLEX_M2W_CATS_ACTUAL != nil && REAL_COMPLEX_M2W_CATS_EXPECTED then
					assert_match REAL_COMPLEX_M2W_CATS_EXPECTED, response
				end
				if REAL_COMPLEX_M2W_KEYS_ACTUAL != nil && REAL_COMPLEX_M2W_KEYS_EXPECTED then
					assert_match REAL_COMPLEX_M2W_KEYS_EXPECTED, response
				end
				if REAL_COMPLEX_M2W_TAGS_ACTUAL != nil && REAL_COMPLEX_M2W_TAGS_EXPECTED then
					assert_match REAL_COMPLEX_M2W_TAGS_EXPECTED, response
				end
				assert_match message, response
			end
		end
	end

end
