# coding: UTF-8

module MetaWeblogPostCommon

	def post_attachments(client, username, password, blogid, postid, header, vars, attachments, dateCreated, errors, warnings)
		M2W_LOGGER.debug("Start  post_attachments ... header = #{header.to_s}, vars = #{vars.to_s}")

		thumbnail_setting = __get_thumbnail_setting(header, vars)
		M2W_LOGGER.debug("__get_thumbnail_setting ... thumbnail_setting = #{thumbnail_setting.to_s}")		

		# 添付ファイルを投稿する
		attachment_urls = {}
		thumbnail_urls = {}
		if attachments != nil && attachments.size > 0 then
			attachment_index = 1
			attachments.each do |attachment|
				# 通常画像を投稿する
				begin
					M2W_LOGGER.debug("Start  metaWeblog.newMediaObject ... index = #{attachment_index}, filename = #{attachment.filename}")
					media_name = @parent.get_attachment_filepath(postid, dateCreated, attachment_index, attachment.filename)
					media_result = client.call("metaWeblog.newMediaObject", blogid, username, password,
						{"bits" => XMLRPC::Base64.new(attachment.content), "name" => media_name}
					)
					if media_result != nil && media_result.has_key?('url') then
						media_url = __modify_media_url(media_result['url'], media_name)
						M2W_LOGGER.debug("post attachment media_result ... media_result = #{media_result.to_s}, media_url = #{media_url}")
						attachment_urls[attachment_index] = media_url
					else
						errors.push(WeblogPluginError.new(
							"添付ファイル転送エラー(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
							"添付ファイルの転送に失敗しました(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
					end
					M2W_LOGGER.debug("Finish metaWeblog.newMediaObject")
				rescue => e
					attachment_urls[attachment_index] = nil
					M2W_LOGGER.error("添付ファイルの転送に失敗しました。")
					M2W_LOGGER.error(e)
					errors.push(WeblogPluginError.new(
						"添付ファイル転送エラー(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
						"添付ファイルの転送に失敗しました(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
				end

				# サムネイル画像を投稿する
				if M2W_SYSTEM_RMAGICK_SUPPORTED then
					begin
						thumbnail = __create_thumbnail(attachment.content, thumbnail_setting, attachment_index.to_s)
					rescue => e
						M2W_LOGGER.error("サムネイルの作成に失敗しました。")
						M2W_LOGGER.error(e)
						errors.push(WeblogPluginError.new(
							"サムネイル作成エラー(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
							"サムネイルの作成に失敗しました(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
					end

					if thumbnail != nil then
						M2W_LOGGER.debug("create thumbnail ... index = #{attachment_index}, filename = #{attachment.filename}")

						begin
							M2W_LOGGER.debug("Start  metaWeblog.newMediaObject ... index = #{attachment_index}, filename = #{attachment.filename}")
							media_name = @parent.get_thumbnail_filepath(postid, dateCreated, attachment_index, attachment.filename)
							media_result = client.call("metaWeblog.newMediaObject", blogid, username, password,
								{"bits" => XMLRPC::Base64.new(thumbnail.to_blob), "name" => media_name}
							)
							if media_result != nil && media_result.has_key?('url') then
								media_url = __modify_media_url(media_result['url'], media_name)
								M2W_LOGGER.debug("post thumbnail media_result ... media_result = #{media_result.to_s}, media_url = media_url")
								thumbnail_urls[attachment_index] = media_url
							else
								thumbnail_urls[attachment_index] = nil
								errors.push(WeblogPluginError.new(
									"サムネイル転送エラー(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
									"サムネイル転送に失敗しました(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
							end
							M2W_LOGGER.debug("Finish metaWeblog.newMediaObject")
						rescue => e
							thumbnail_urls[attachment_index] = nil
							M2W_LOGGER.error("添付ファイルの転送に失敗しました。")
							M2W_LOGGER.error(e)
							errors.push(WeblogPluginError.new(
								"サムネイル転送エラー(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})",
								"サムネイルの転送に失敗しました(添付インデックス = #{attachment_index}, 添付ファイル名 = #{attachment.filename})。"))
						end
					end
				end

				attachment_index = attachment_index + 1
			end
		end

		M2W_LOGGER.debug("Finish post_attachments ... attachment_urls = #{attachment_urls.to_s}, thumbnail_urls = #{thumbnail_urls.to_s}")
		return [attachment_urls, thumbnail_urls]
	end

	def get_header_for_post(header)
		result = header.clone
		result.delete_if do |key, value|
			key == M2W_FORMAT_PLUGIN_CONF_HEADER_NAME || key =~ /^fmt_[0-9a-zA-Z]+$/
		end

		return result
	end

	def __get_thumbnail_setting(header, vars)
		M2W_LOGGER.debug("Start  #{self.class}#__get_thumbnail_setting ... header = #{header.to_s}, vars = #{vars.to_s}")

		result = {}
		if header.has_key?('thumbnail_scale') then
			result[0] = {'scale' => header['thumbnail_scale'].to_i}
		elsif header.has_key?('thumbinal_width') && header.has_key?('thumbinal_height') then
			result[0] = {'width' => header['thumbnail_width'].to_i, 'height' => header['thumbnail_height'].to_i}
		end

		if vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME] != nil && vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME].has_key?(M2W_WEBLOG_PLUGIN_CONF_THUMBNAIL_VAR_NAME) then
			M2W_LOGGER.debug("has thumbnail setting ... #{vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][M2W_WEBLOG_PLUGIN_CONF_THUMBNAIL_VAR_NAME].to_s}")
			vars[M2W_FORMAT_PLUGIN_CONF_HEADER_NAME][M2W_WEBLOG_PLUGIN_CONF_THUMBNAIL_VAR_NAME].each do |index, thumbnail_presetting|
				result[index.to_s] = thumbnail_presetting
			end
		end

		M2W_LOGGER.debug("Finish #{self.class}#__get_thumbnail_setting ... result = #{result.to_s}")
		return result
	end

	def __create_thumbnail(attachment_content, thumbnail_setting, attachment_index)
		M2W_LOGGER.debug("Start  #{self.class}#__create_thumbnail ... thumbnail_setting = #{thumbnail_setting.to_s}, attachment_index = #{attachment_index}")

		setting = thumbnail_setting[0]
		if thumbnail_setting[attachment_index] != nil then
			setting = thumbnail_setting[attachment_index]
		end

		begin
			if setting != nil then
				M2W_LOGGER.debug("setting ... #{setting.to_s}")
				if setting['scale'] != nil then
					return Magick::Image.from_blob(attachment_content).shift.scale(0.01 * setting['scale'].to_i)
				elsif setting['width'] != nil && setting['height'] != nil then
					return Magick::Image.from_blob(attachment_content).shift.scale(setting['width'].to_i, setting['height'].to_i)
				end
			end

			return nil
		ensure
			M2W_LOGGER.debug("Finish #{self.class}#__create_thumbnail")
		end
	end

	def __modify_media_url(media_url, media_name)
		if %r!^(.+?)(/?)#{media_name}$! =~ media_url then
			return "#{$1}/#{media_name}"
		else
			return media_url
		end
	end

end
