# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'

#=ブログ記事取得コマンド
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: get.rb 443 2011-12-21 06:59:27Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Get_CommandPlugin < StandardCommand

	def parse_mail_content
		content = @mail_parser.escaped_prefix_content(@mail.content, 'postid\.')
		return @mail_parser.parse_content(content, header_alias())
	end

	def run_before_parsing
		if @weblog != nil then
			@get_plugin = @weblog.get_get_plugin
		end
	end

	def header_alias()
		result = {}

		if @get_plugin != nil then
			result = result.merge(@get_plugin.header_alias)
		end

		return result
	end

	def run_after_parsing(header, content, contents)
		@report = {}

		if M2W_REPLY && @mail_sender != nil && @get_plugin != nil then
			(command, blogid) = @mail_parser.parse_subject(@mail.escaped_prefix_subject)

			result = @get_plugin.get(header, content, @mail.attachments, @param)
			@report = @get_plugin.report.clone
			@report[:errors] = @get_plugin.errors
			@report[:warnings] = @get_plugin.warnings

			if result then
				(send_header, send_content) = @mail_parser.parse_content(@report[:original_content], {})
				header_with_postid = get_header_with_postid(send_header, header['postid'])
				@mail_sender.sendmail_as_command(
					"edit",
					blogid,
					header_with_postid,
					send_content,
					@mail.from_address,
					@report[:attachments].clone.delete_if{|attachment| attachment == nil})
			else
send_content = <<"END_CONTENT"
ブログ記事の取得に失敗しました。
#{make_exception_contents(@get_plugin.errors, @get_plugin.warnings)}
END_CONTENT
				@mail_sender.sendmail_as_command("error", blogid, {}, send_content, @mail.from_address, [])
			end

			return result
		end

		return false
	end

	def get_header_with_postid(header, postid)
		result = ["postid", postid]

		if header.kind_of?(Hash) then
			header.each do |key, value|
				if key != 'postid' then
					result.push(key)
					result.push(value)
				end
			end
		elsif header.kind_of?(Array) then
			i = 0
			while i < header.size
				key   = header[i + 0]
				value = header[i + 1]
				if key != 'postid' then
					result.push(key)
					result.push(value)
				end

				i = i + 2
			end
		end

		return result
	end

end
