# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'blogger/blogger'
require 'conf/setting'

require 'uri'
require 'minitest/unit'

MiniTest::Unit.autorun

#=blogger API のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_blogger.rb 365 2011-11-22 01:50:48Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestBlogger < MiniTest::Unit::TestCase

	if REAL_TEST then
		def test_get_users_blogs
			uri = URI.parse(M2W_WEBLOG_ENDPOINT)
			client = XMLRPC::Client.new(uri.host, uri.path)
			client.set_parser(XMLRPC_PARSER) if XMLRPC_PARSER != nil
			blogger = Blogger.new(client, M2W_WEBLOG_USERNAME, M2W_WEBLOG_PASSWORD, M2W_SYSTEM_INNER_ENCODING)
			result = blogger.get_users_blogs()
			BLOGS.each do |blogid, blog|
				assert result[blogid] != nil, result.to_s
				assert_equal blog[0], result[blogid].blogid
				assert_equal blog[1], result[blogid].url
				assert_equal blog[2], result[blogid].blog_name
			end
		end
	end

end
