# coding: UTF-8

#=mail2weblog の標準のリクエスト形式を定義する。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_request.rb 621 2012-03-17 02:36:35Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Mail2WeblogRequest

	attr_accessor :mail
	attr_accessor :header
	attr_accessor :content
	attr_accessor :contents
	attr_accessor :attachments
	attr_accessor :html_content
	attr_accessor :html_contents
	attr_accessor :related_attachments

	def initialize(mail, header, content, contents = {}, attachments = [], html_content = nil, html_contents = nil, related_attachments = [])
		@mail = mail
		@header = header
		@content = content
		@contents = contents
		@attachments = attachments
		@html_content = html_content
		@html_contents = html_contents
		@related_attachments = related_attachments
	end

	def original_content
		return @mail.content
	end

	def original_html_content
		return @mail.html_content
	end

end
