# coding: UTF-8

require 'plugin/weblog/atom_pub/atom_pub_post'

#=はてなダイアリーのためのブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_post.rb 621 2012-03-17 02:36:35Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryPost_WeblogPlugin < AtomPubPost_WeblogPlugin

	def post_medias(client, username, password, blogid, media_posters, errors, warnings)
		M2W_LOGGER.debug("Start  #{self.class.name}#post_medias")
		if media_posters != nil then
			media_posters.each do |media_poster|
				warnings.push(WeblogPluginError.new(
					"ファイル転送未対応(転送ファイル名 = #{media_poster.media_name})",
					"ファイルの転送に対応していません（転送ファイル名 = #{media_poster.media_name}）。"))
			end
		end
		M2W_LOGGER.debug("Finish #{self.class.name}#post_medias")
	end

	def parse_postid(entry_uri)
		if %r!/(([0-9]+/)?[0-9]+)$! =~ entry_uri then
			return $1
		else
			return nil
		end
	end

	def after(client, request, blogid, postid, errors, warnings)
		super

		request_trackback(client, request.header, blogid)
	end

end
