# coding: UTF-8

require 'plugin/weblog/lib/standard_command'
require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/lib/weblog_plugin_warning'

require 'open-uri'

#=標準のブログ記事削除用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_delete.rb 648 2012-03-30 00:37:27Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class StandardDelete_WeblogPlugin < StandardCommand_WeblogPlugin

	def delete(request)
		M2W_LOGGER.debug("Start  #{self.class.name}#delete ... endpoint = #{@parent.endpoint}, header = #{request.header.to_s}")
		result = false

		client = @parent.client
		formatter = @parent.formatter

		postid = request.header['postid']

		before(client, request, postid, @errors, @warnings)

		begin
			result = delete_article(client, postid)
		rescue => e
			M2W_LOGGER.error("ブログ記事の削除に失敗しました。")
			M2W_LOGGER.error(e)
			@errors.push(WeblogPluginError.new(
				"ブログ記事削除エラー(メッセージ = #{e.message})",
				"ブログ記事の削除に失敗しました(メッセージ = #{e.message})。"))
			M2W_LOGGER.debug("Finish #{self.class.name}#delete ... result = false")
			return false
		end

		@report[:postid] = postid.to_s

		after(client, request, postid, @errors, @warnings)

		M2W_LOGGER.debug("Finish #{self.class.name}#delete ... result = #{result}")
		return result
	end

	def header_alias
		return {}
	end

	def before(client, request, postid, errors, warnings)
	end

	def after(client, request, postid, errors, warnings)
	end

	def delete_article(client, postid)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

end
