# coding: UTF-8

if $0 == __FILE__ then
	begin
		require 'rubygems'
	rescue LoadError
	end

	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../")
	$:.unshift(ROOT_PATH + "/../../main/")
	$:.unshift(ROOT_PATH + "/../../main/lib/")

	require 'minitest/autorun'
end

require 'conf/01_system/ruby_version_absorber'
require 'mailutils/mime'

#=Mime のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_mime.rb 675 2012-05-12 15:12:21Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestMime < MiniTest::Unit::TestCase

	def test_mime
		mime = Mime.new
		assert_equal 'image/jpeg', mime.mime('filename.jpg')
		assert_equal 'image/jpeg', mime.mime('filename.jpeg')
		assert_equal 'image/gif', mime.mime('filename.gif')
	end

end
