# coding: UTF-8

require 'net/http'

PERMISIBBLE_ERROR_FREQUENCY = 10

#=HTTP ANZT[
#
# ŏ̒:: gDC[
# |Wg:: $Id: accessor.rb 773 2012-07-10 03:59:20Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class Accessor

	def Accessor.separate_host_address(url)
		if %r!^http://(.+?)(/.*)$! =~ url then
			return [$1, $2]
		else
			return nil
		end
	end

	def Accessor.access_url(url, encoding = nil, permisibble_error_frequency = PERMISIBBLE_ERROR_FREQUENCY, open_timeout = nil, read_timeout = nil)
		(host, address) = Accessor.separate_host_address(url)
		return Accessor.access(host, address, encoding, permisibble_error_frequency, open_timeout, read_timeout)
	end

	def Accessor.access(host, address, encoding = nil, permisibble_error_frequency = PERMISIBBLE_ERROR_FREQUENCY, open_timeout = nil, read_timeout = nil)
		M2W_LOGGER.debug("Start  #{self.class.name}#access ... addresss = #{@pop3_address}, port = #{@pop3_port}, user = #{@pop3_user}")

		response = nil
		error_frequency = 0
		while response == nil
			begin
				Net::HTTP.start(host) do |http|
					http.open_timeout = open_timeout if open_timeout != nil
					http.read_timeout = read_timeout if read_timeout != nil
					response = http.get(address)
					case response
					when Net::HTTPSuccess
					else
						error_frequency = error_frequency + 1
						response = nil
						if error_frequency >= permisibble_error_frequency then
							M2W_LOGGER.debug("Finish #{self.class.name}#access ... result = failed, error_frequency = #{error_frequency}")
							return nil
						end
					end
				end
			rescue => e
				error_frequency = error_frequency + 1
				response = nil
				if error_frequency >= permisibble_error_frequency then
					raise e
				end
			end
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#access ... result = successed, error_frequency = #{error_frequency}")
		if encoding != nil then
			return response.body.encode(encoding, encoding)
		else
			return response.body
		end
	end

end
