# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'

#=ブログ記事編集コマンドプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: edit.rb 895 2012-12-18 10:26:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Edit_CommandPlugin < StandardCommand

	def edit_plugin
		return @edit_plugin if @edit_plugin
		@edit_plugin = @weblog.get_edit_plugin
		@edit_plugin.logger = @logger if @edit_plugin
		return @edit_plugin
	end

	def header_alias()
		result = {}

		result = result.merge(edit_plugin.header_alias) if edit_plugin

		return result
	end

	def run_after_parsing(request)
		if edit_plugin then
			return edit_plugin.edit(request)
		else
			return Mail2WeblogResponse.new
		end
	end

end
