# coding: UTF-8

require 'style/formatter'

M2W_WEBLOG_TDIARY_LINE_BREAK = "&lb;"

#=tDiary のための専用フォーマッター
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: t_diary_formatter.rb 830 2012-10-02 16:04:39Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TDiaryFormatter < Formatter

	def escape(content)
		result = CGI.escapeHTML(content)
		return result.gsub(/\n/, M2W_WEBLOG_TDIARY_LINE_BREAK)
	end

	def unescape(content)
		result = content.gsub(M2W_WEBLOG_TDIARY_LINE_BREAK, "\n")
		return CGI.unescapeHTML(result)
	end

end
