# coding: UTF-8

require 'style/formatter'

M2W_WEBLOG_WORD_PRESS_LINE_BREAK = "&lb;"
M2W_WEBLOG_WORD_PRESS_LEFT_SQUARE_BRACKET = "&lsb;"
M2W_WEBLOG_WORD_PRESS_RIGHT_SQUARE_BRACKET = "&rsb;"

#=WordPress のための専用フォーマッター
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: word_press_formatter.rb 895 2012-12-18 10:26:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class WordPressFormatter < Formatter

	def escape(content)
		result = CGI.escapeHTML(content)
		result = result.gsub(/\n/, M2W_WEBLOG_WORD_PRESS_LINE_BREAK)
		result = result.gsub(/\[/, M2W_WEBLOG_WORD_PRESS_LEFT_SQUARE_BRACKET)
		result = result.gsub(/\]/, M2W_WEBLOG_WORD_PRESS_RIGHT_SQUARE_BRACKET)
		return result
	end

	def unescape(content)
		result = content
		result = result.gsub(M2W_WEBLOG_WORD_PRESS_RIGHT_SQUARE_BRACKET, "]")
		result = result.gsub(M2W_WEBLOG_WORD_PRESS_LEFT_SQUARE_BRACKET, "[")
		result = result.gsub(M2W_WEBLOG_WORD_PRESS_LINE_BREAK, "\n")
		return CGI.unescapeHTML(result)
	end

end
