# coding: UTF-8

if $0 == __FILE__ then
	ROOT_PATH = File.dirname(File.expand_path(__FILE__))

	$:.unshift(ROOT_PATH + "/../../../")
	$:.unshift(ROOT_PATH + "/../../../../main/")
	$:.unshift(ROOT_PATH + "/../../../../main/lib/")

	# mail2weblog のルートパスを設定する
	M2W_ROOT_PATH = ROOT_PATH + "/../../../../main/"

	require 'm2w_configurator'
	require 'minitest/autorun'
end

#=PREformatted text（整形済みテキスト）を出力する書式プラグインのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_pre_plugin.rb 675 2012-05-12 15:12:21Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestPreFormatPlugin < MiniTest::Unit::TestCase

	def test_plugin_contents
		plugin = Pre_FormatPlugin.new()

expected = <<"END_CONTENT"
abc
def
ghi
END_CONTENT

content = <<"END_CONTENT"

abc
def
ghi
END_CONTENT

		result = plugin.plugin_contents(content, {})
		assert_equal "<div><pre>#{expected}</pre></div>", result.chomp('')
	end

	def test_plugin_contents_inline
		plugin = Pre_FormatPlugin.new()

expected = <<"END_CONTENT"
abc
def
ghi
END_CONTENT

content = <<"END_CONTENT"

abc
def
ghi
END_CONTENT

		result = plugin.plugin_contents_inline(content, {})
		assert_equal "<span><pre>#{expected}</pre></span>", result.chomp('')
	end

end
