#
# Cookbook Name:: apt_utils
# Recipe:: aptly-docker-compose
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

doc_url = 'https://www.aptly.info/doc/overview/'

include_recipe 'platform_utils::kernel_user_namespace'
include_recipe 'docker-grid::compose'

app_dir = node['apt_utils']['aptly']['docker-compose']['app_dir']
data_dir = node['apt_utils']['aptly']['docker-compose']['data_dir']
etc_dir = node['apt_utils']['aptly']['docker-compose']['etc_dir']

[
  app_dir,
  etc_dir,
  "#{etc_dir}/nginx",
].each {|dir|
  resources(directory: dir) rescue directory dir do
    owner 'root'
    group 'root'
    mode '0755'
    recursive true
  end
}

override_aptly_conf = node.override['apt_utils']['aptly']['conf']

config_srvs = node['apt_utils']['aptly']['docker-compose']['config']['services']
override_config_srvs = node.override['apt_utils']['aptly']['docker-compose']['config']['services']
#force_override_config_srvs = node.force_override['apt_utils']['aptly']['docker-compose']['config']['services']
#aptly_envs_org = config_srvs['aptly']['environment']
#aptly_envs = {}
rproxy_vols = config_srvs['reverseproxy']['volumes'].to_a
aptly_vols = config_srvs['aptly']['volumes'].to_a

ports = config_srvs['reverseproxy']['ports']
override_config_srvs['reverseproxy']['ports'] = ['8080:8080', '8081:8081'] if ports.empty?

template "#{etc_dir}/nginx/nginx.conf" do
  source 'opt/docker-compose/app/aptly/etc/nginx/nginx.conf'
  owner 'root'
  group 'root'
  mode '0644'
  action :create
end

rproxy_vols.push("#{etc_dir}/nginx/nginx.conf:/etc/nginx/nginx.conf:ro")

override_aptly_conf['rootDir'] = '/aptly-data'
template "#{etc_dir}/aptly.conf" do
  source  'etc/aptly.conf'
  owner 'root'
  group 'root'
  mode '0644'
  action :create
end

aptly_vols.push("#{etc_dir}/aptly.conf:/etc/aptly.conf:rw")

# Data persistent
if !data_dir.nil? && !data_dir.empty?
  resources(directory: data_dir) rescue directory data_dir do
    owner 'root'
    group 'root'
    mode '0700'
    recursive true
  end

  aptly_vols.push("#{data_dir}:/aptly-data:rw")
end

if node['apt_utils']['aptly']['with_ssl_cert_cookbook']
  ::Chef::Recipe.send(:include, SSLCert::Helper)
  cn = node['apt_utils']['aptly']['ssl_cert']['common_name']
  # Concourse web process owner is root.
  rproxy_vols.push("#{server_cert_path(cn)}:/root/server.crt:ro")
  rproxy_vols.push("#{server_key_path(cn)}:/root/server.key:ro")
end

# merge environment hash
#force_override_config_srvs['aptly']['environment'] = envs unless aptly_envs.empty?
# reset vlumes array.
override_config_srvs['reverseproxy']['volumes'] = rproxy_vols unless rproxy_vols.empty?
override_config_srvs['aptly']['volumes'] = aptly_vols unless aptly_vols.empty?

config_file = "#{app_dir}/docker-compose.yml"
template config_file do
  source  'opt/docker-compose/app/aptly/docker-compose.yml'
  owner 'root'
  group 'root'
  mode '0644'
end

log <<-"EOM"
Note: You must execute the following command manually.
  See #{doc_url}
  - Start:
    $ cd #{app_dir}
    $ docker-compose up -d
  - Stop
    $ docker-compose down
EOM
