#
# Copyright 2013-2014, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'

name 'pleiades-node'
description 'Pleiades cluster node'

run_list(
  'role[hadoop-pleiades-with-security]',
  'role[hbase-pleiades-with-security]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

cluster = Grid::CLUSTERS[:pleiades]

#default_attributes

override_attributes(
  'hadoop' => {
    'version' => '1.0.4',
    'metrics2' => {
      # multi-cast
      'namenode.sink.ganglia.servers'    => "#{cluster[:namenodes][:mcast_addr]}:8649",
      'datanode.sink.ganglia.servers'    => "#{cluster[:datanodes][:mcast_addr]}:8649",
      'jobtracker.sink.ganglia.servers'  => "#{cluster[:jobtrackers][:mcast_addr]}:8649",
      'tasktracker.sink.ganglia.servers' => "#{cluster[:datanodes][:mcast_addr]}:8649",
      'maptask.sink.ganglia.servers'     => "#{cluster[:datanodes][:mcast_addr]}:8649",
      'reducetask.sink.ganglia.servers'  => "#{cluster[:datanodes][:mcast_addr]}:8649"
    }
  },
  'hbase' => {
    'version' => '0.94.7'
  }
)

