name 'gitlab-on-docker'
description 'GitLab on Docker'

gitlab_cn = 'gitlab.io.example.com'
gitlab_http_port = '8080'
gitlab_ssh_port = '2022'

run_list(
  'role[docker]',
  'recipe[gitlab-grid::docker-compose]',
)

#env_run_lists()

#default_attributes()

override_attributes(
  'docker-grid' => {
    'engine' => {
      'skip_setup' => false,
    },
    'compose' => {
      'skip_setup' => false,
    },
  },
  'gitlab-grid' => {
    'gitlab.rb' => {
      'external_url' => "http://#{gitlab_cn}:#{gitlab_http_port}",
      'gitlab_rails' => {
        'time_zone' => 'UTC',
        #'time_zone' => 'Asia/Tokyo',
        'gitlab_shell_ssh_port' => gitlab_ssh_port.to_i,
      },
      'nginx' => {
        'redirect_http_to_https' => false,
      },
    },
    'docker-compose' => {
      'config' => {
        # Version 2 docker-compose format
        'version' => '2',
        'services' => {
          'gitlab' => {
            'restart' => 'always',
            'image' => 'gitlab/gitlab-ce:latest',
            'hostname' => gitlab_cn,
            'ports' => [
              "#{gitlab_http_port}:#{gitlab_http_port}",
              "#{gitlab_ssh_port}:22",
            ],
          },
        },
      },
    },
  },
)
