#
# Cookbook Name:: ganglia
# Recipe Spec:: gmond_spec
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require_relative '../spec_helper'

describe 'ganglia::gmond' do
  let(:chef_run_on_debian) {
    ChefSpec::SoloRunner.new(platform: 'debian', version: '7.6') {|node|
      node.set['ganglia']['host']['location'] = 'specified'
    }.converge(described_recipe)
  }

  it 'installs ganglia-monitor package on debian family.' do
    expected = expect(chef_run_on_debian)
    expected.to install_package('ganglia-monitor')
    expected.to enable_service('ganglia-monitor')
  end

  it 'renders /etc/ganglia/gmond.conf on debian family.' do
    expect(chef_run_on_debian).to \
      render_file('/etc/ganglia/gmond.conf').
        with_content(%r|^\s+location\s+=\s+"specified"$|)
  end

  it 'notifies ganglia-monitor service\'s restart after rendering on debian family.' do
    expect(chef_run_on_debian.template('/etc/ganglia/gmond.conf')).to \
      notify('service[ganglia-monitor]').to(:restart).delayed
  end

  let(:chef_run_on_rhel) {
    ChefSpec::SoloRunner.new(platform: 'centos', version: '7.0') {|node|
      node.set['ganglia']['host']['location'] = 'specified'
    }.converge(described_recipe)
  }

  it 'installs ganglia-gmond package on rhel family.' do
    expected = expect(chef_run_on_rhel)
    expected.to install_package('ganglia-gmond')
    expected.to enable_service('gmond')
  end

  it 'renders /etc/ganglia/gmond.conf on rhel family.' do
    expect(chef_run_on_rhel).to \
      render_file('/etc/ganglia/gmond.conf').
        with_content(%r|^\s+location\s+=\s+"specified"$|)
  end

  it 'notifies gmond service\'s restart after rendering on rhel family.' do
    expect(chef_run_on_rhel.template('/etc/ganglia/gmond.conf')).to \
      notify('service[gmond]').to(:restart).delayed
  end
end

