#
# Cookbook Name:: node_commons
# Recipe Spec:: default_spec
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require_relative '../spec_helper'

describe 'node_commons::default' do
  let(:chef_run_on_debian) {
    ChefSpec::SoloRunner.new(platform: 'debian', version: '7.6').
      converge(described_recipe)
  }

  it 'installs ntp package.' do
    expect(chef_run_on_debian).to install_package('ntp')
  end

  it 'enables ntp service.' do
    expect(chef_run_on_debian).to enable_service('ntp')
    expect(chef_run_on_debian).to start_service('ntp')
  end

  let(:chef_run_on_rhel) {
    ChefSpec::SoloRunner.new(platform: 'centos', version: '7.0').
      converge(described_recipe)
  }

  it 'installs ntp package.' do
    expect(chef_run_on_rhel).to install_package('ntp')
  end

  it 'enables ntpd service.' do
    expect(chef_run_on_rhel).to enable_service('ntpd')
    expect(chef_run_on_rhel).to start_service('ntpd')
  end
end

