#
# Cookbook Name:: dcos-grid
# Attributes:: default
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['dcos-grid']['dcos_release_url'] = 'https://downloads.dcos.io/dcos/EarlyAccess/dcos_generate_config.sh'
default['dcos-grid']['dcos_cli_release_url'] = 'https://downloads.dcos.io/binaries/cli/linux/x86-64/0.4.10/dcos'
default['dcos-grid']['docker']['apt_repo'] = {
  'url' => 'https://apt.dockerproject.org/repo',
  'keyserver' => 'hkp://p80.pool.sks-keyservers.net:80',
  'recv-keys' => '58118E89F3A912897C070ADBF76221572C52609D',
}
default['dcos-grid']['docker']['yum_repo'] = {
  'baseurl' => 'https://yum.dockerproject.org/repo/main/centos/$releasever/',
  'gpgcheck' => '1',
  'gpgkey' => 'https://yum.dockerproject.org/gpg',
}
default['dcos-grid']['docker-engine']['setup'] = true
default['dcos-grid']['docker-engine']['version_on_centos'] = '1.11.2-1'
default['dcos-grid']['docker-engine']['version_on_ubuntu'] = '1.11.2-0'
default['dcos-grid']['docker-engine']['version'] = node.value_for_platform(
  ['centos', 'redhat'] => {
    'default' => "#{node['dcos-grid']['docker-engine']['version_on_centos']}.el#{node['platform_version'].to_i}.#{node['platform']}",
  },
  'ubuntu' => {
    'default' => "#{node['dcos-grid']['docker-engine']['version_on_ubuntu']}~#{node['lsb']['codename']}",
  }
)
default['dcos-grid']['bootstrap']['ip'] = '127.0.0.1'
default['dcos-grid']['bootstrap']['port'] = '8080'
default['dcos-grid']['bootstrap']['genconf_dir'] = '/opt/dcos-grid/genconf'
default['dcos-grid']['bootstrap']['config'] = {
  'bootstrap_url' => "http://#{node['dcos-grid']['bootstrap']['ip']}:#{node['dcos-grid']['bootstrap']['port']}",
  'cluster_name' => 'dcos0',
  'exhibitor_storage_backend' => 'static',
  'ip_detect_filename' => '/genconf/ip-detect',
  'master_discovery' => 'static',
  'master_list' => [
    #'192.168.56.101',
    #'192.168.56.102',
    #'192.168.56.103',
  ],
  'oauth_auth_host' => 'https://dcos.auth0.com',
  'oauth_auth_redirector' => 'https://auth.dcos.io',
  'oauth_available' => 'true',
  'oauth_enabled' => 'true',
  'oauth_issuer_url' => 'https://dcos.auth0.com/',
  'resolvers' => [
    #'8.8.8.8',
    #'8.8.4.4',
  ],
}
default['dcos-grid']['bootstrap']['ip-detect'] = {
  'interface' => 'eth0',
}
default['dcos-grid']['node']['auto_setup'] = false
default['dcos-grid']['cloud-config'] = {
  'target_platform' => 'coreos',  # coreos only now.
  'target_dir' => '/home/core',
  'target_owner' => 'core:core',
  'hostname' => '<fqdn>',
  'ssh_authorized_keys' => [
    '<your_ssh_pub_key>',
  ],
}
