#
# Cookbook Name:: apache_utils
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['apache_utils']['mirror']['user'] = 'apache-mirror'
default['apache_utils']['mirror']['cron_period'] = '#0 2	* * *'  # default: inactive
default['apache_utils']['mirror']['base_path'] = '/var/spool/apache-mirror'
default['apache_utils']['mirror']['rsync_sources'] = [
  # Apache
  # http://www.apache.org/info/how-to-mirror.html
  {
    'url' => 'rsync.apache.org::apache-dist',
    #'url' => 'rsync.apache.org::apache-dist-most',
    'rsync_opts' => '-avSH --stats --partial --delete --safe-links',
    'http_alias' => '/apache'
  }
]

