name 'lxd'
description 'LXD role.'

run_list(
  'recipe[lxcs::lxd]',
)

#env_run_lists()

#default_attributes()

override_attributes(
  'lxcs' => {
    'lxd' => {
      'with_zfs' => false,
      'users_allow' => [
        #'alice',
      ],
      'init' => {
        'enabled' => true,
        'options' => [
          #"--network-address #{node['ipaddress']}",
          #'--network-port 8443',
          '--storage-backend dir',
        ].join(' '),
      },
      # Ubuntu >= 16.10
      'network' => {
        'lxdbr0' => {
          'config' => {
            'dns.mode' => 'dynamic',
            'ipv4.address' => '10.1.3.1/24',
            'ipv4.dhcp.ranges' => '10.1.3.200-10.1.3.254',
            'ipv4.nat' => 'true',
            'ipv6.address' => 'none',
          },
          'managed' => 'true',
          'type' => 'bridge',
        },
      },
      'bridge' => {
        'enabled' => true,
        # Deprecated: Ubuntu <= 16.04
        # use `lxc network set` command on 16.10 (yakkety) or later
        'conf' => {
          'USE_LXD_BRIDGE' => 'true',
          'LXD_BRIDGE' => 'lxdbr0',
          'UPDATE_PROFILE' => 'true',
          'LXD_CONFILE' => '',
          'LXD_DOMAIN' => 'lxd',
          'LXD_IPV4_ADDR' => '10.1.3.1',
          'LXD_IPV4_NETMASK' => '255.255.255.0',
          'LXD_IPV4_NETWORK' => '10.1.3.1/24',
          'LXD_IPV4_DHCP_RANGE' => '10.1.3.200,10.1.3.254',
          'LXD_IPV4_DHCP_MAX' => '55',
          'LXD_IPV4_NAT' => 'true',
          'LXD_IPV6_ADDR' => '',
          'LXD_IPV6_MASK' => '',
          'LXD_IPV6_NETWORK' => '',
          'LXD_IPV6_NAT' => 'false',
          'LXD_IPV6_PROXY' => 'false',
        },
      },
    },
  },
)
